/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.etl.common.manager.connection;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import org.clawiz.core.common.Core;
import org.clawiz.core.common.system.config.Config;
import org.clawiz.core.common.system.database.Connection;
import org.clawiz.core.common.system.database.Statement;
import org.clawiz.core.common.system.database.datasource.DataSource;
import org.clawiz.core.common.system.database.datasource.DataSourceConfig;
import org.clawiz.core.common.system.session.Session;
import org.clawiz.core.common.utils.RandomGUID;
import org.clawiz.core.common.utils.StringUtils;
import org.clawiz.etl.common.manager.connection.AbstractConnection;

public class AbstractJDBCConnection
extends AbstractConnection {
    public static final String URL_CONNECTION_CONFIG_PATH = "url";
    public static final String USER_CONNECTION_CONFIG_PATH = "user";
    public static final String PASSWORD_CONNECTION_CONFIG_PATH = "password";
    public static final String CONNECTION_POOL_MAX_SIZE_CONNECTION_CONFIG_PATH = "connection-pool.maximum-size";
    public static final int DEFAULT_CONNECTION_POOL_MAX_SIZE = 3;
    private boolean connectionConfigPrepared = false;
    private Config connectionConfig = null;
    Connection connection;
    private static HashMap<Class, DataSource> dataSourcesCache = new HashMap();
    private DataSource _dataSource;

    public Config getConnectionConfig() {
        return null;
    }

    private void prepareConnectionConfig() {
        if (!this.connectionConfigPrepared) {
            this.connectionConfig = this.getConnectionConfig();
            this.connectionConfigPrepared = true;
        }
    }

    protected String getConnectionConfigString(String path) {
        this.prepareConnectionConfig();
        return this.connectionConfig != null ? this.connectionConfig.getString(path) : null;
    }

    protected String getUrl() {
        return this.getConnectionConfigString(URL_CONNECTION_CONFIG_PATH);
    }

    protected String getUsername() {
        return this.getConnectionConfigString(USER_CONNECTION_CONFIG_PATH);
    }

    protected String getPassword() {
        return this.getConnectionConfigString(PASSWORD_CONNECTION_CONFIG_PATH);
    }

    protected int getConnectionPoolMaxSize() {
        String str = this.getConnectionConfigString(CONNECTION_POOL_MAX_SIZE_CONNECTION_CONFIG_PATH);
        return str != null ? StringUtils.toBigDecimal((String)str).intValue() : 3;
    }

    protected synchronized DataSource getDataSource() {
        if (this._dataSource != null) {
            return this._dataSource;
        }
        this._dataSource = dataSourcesCache.get(((Object)((Object)this)).getClass());
        if (this._dataSource != null) {
            return this._dataSource;
        }
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        dataSourceConfig.setJdbcUrl(this.getUrl());
        dataSourceConfig.setUsername(this.getUsername());
        dataSourceConfig.setPassword(this.getPassword());
        dataSourceConfig.setAutoCommit(false);
        dataSourceConfig.setConnectionPoolMaxSize(this.getConnectionPoolMaxSize());
        this._dataSource = Core.createDataSource((DataSourceConfig)dataSourceConfig);
        dataSourcesCache.put(((Object)((Object)this)).getClass(), this._dataSource);
        return this._dataSource;
    }

    protected Connection newJdbcConnection() {
        Session newSession = Core.getSessions().newSession(this.getDataSource(), new RandomGUID().toString());
        this.getSession().addChildSession(newSession);
        return newSession.getConnection();
    }

    public synchronized Connection getConnection() {
        if (this.connection == null) {
            this.connection = this.newJdbcConnection();
        }
        return this.connection;
    }

    public Statement executeQuery(String sql, Object ... parameters) {
        Statement statement = this.getConnection().executeQuery(sql, parameters);
        return statement;
    }

    public BigDecimal executeQueryBigDecimal(String sql, Object ... parameters) {
        return this.getConnection().executeQueryBigDecimal(sql, parameters);
    }

    public Date executeQueryDate(String sql, Object ... parameters) {
        return this.getConnection().executeQueryDate(sql, parameters);
    }

    public String executeQueryString(String sql, Object ... parameters) {
        return this.getConnection().executeQueryString(sql, parameters);
    }

    public void done() {
        this.connection.close();
    }
}

