/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.etl.common.manager.instance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.clawiz.etl.common.manager.dataset.DataSetList;
import org.clawiz.etl.common.manager.instance.JobInstanceState;
import org.clawiz.etl.common.manager.instance.step.AbstractJobStepInstance;
import org.clawiz.etl.common.manager.instance.step.JobStepInstanceList;
import org.clawiz.etl.common.manager.instance.step.JobStepInstanceState;
import org.clawiz.etl.common.manager.service.AbstractJobService;
import org.clawiz.etl.common.manager.service.step.AbstractJobStepService;
import org.clawiz.etl.common.metadata.data.job.Job;
import org.clawiz.etl.common.metadata.data.job.step.JobStep;

public abstract class AbstractJobInstance<T extends AbstractJobService> {
    Job job;
    T service;
    JobInstanceState state = JobInstanceState.READY;
    Exception cause;
    JobStepInstanceList steps = new JobStepInstanceList();
    DataSetList dataSets = new DataSetList();
    private ArrayList<AbstractJobStepInstance> _readySteps;
    private HashMap<AbstractJobStepInstance, AbstractJobStepInstance> _readyStepsMap;
    private HashMap<AbstractJobStepInstance, AbstractJobStepInstance> _runStepsMap;

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public JobInstanceState getState() {
        return this.state;
    }

    public void setState(JobInstanceState state) {
        this.state = state;
    }

    public Exception getCause() {
        return this.cause;
    }

    public void setCause(Exception cause) {
        this.cause = cause;
    }

    public T getService() {
        return this.service;
    }

    public void setService(T service) {
        this.service = service;
    }

    public JobStepInstanceList getSteps() {
        return this.steps;
    }

    protected <T extends AbstractJobStepInstance, S extends AbstractJobStepService> T addStepInstance(JobStep jobStep, Class<T> instanceClass, Class<S> serviceClass) {
        AbstractJobStepInstance stepInstance = null;
        try {
            stepInstance = (AbstractJobStepInstance)instanceClass.newInstance();
        }
        catch (Exception e) {
            this.service.throwException("Exception on create step ? instance : ?", new Object[]{jobStep.getFullName(), e.getMessage(), e});
        }
        stepInstance.setJobInstance(this);
        stepInstance.setStep(jobStep);
        stepInstance.setJobInstance(this);
        stepInstance.setService((AbstractJobStepService)this.getService().getService(serviceClass));
        this.steps.add(stepInstance);
        return (T)stepInstance;
    }

    public abstract void prepare();

    public abstract AbstractJobStepInstance getStepInstance(String var1);

    public synchronized ArrayList<AbstractJobStepInstance> getAllowedReadySteps() {
        if (this._readySteps != null) {
            return this._readySteps;
        }
        ArrayList<AbstractJobStepInstance> readySteps = new ArrayList<AbstractJobStepInstance>();
        HashMap<AbstractJobStepInstance, AbstractJobStepInstance> readyStepsMap = new HashMap<AbstractJobStepInstance, AbstractJobStepInstance>();
        HashMap<AbstractJobStepInstance, AbstractJobStepInstance> runStepsMap = new HashMap<AbstractJobStepInstance, AbstractJobStepInstance>();
        HashMap doneSteps = new HashMap();
        for (AbstractJobStepInstance stepInstance : this.getSteps()) {
            if (stepInstance.getState() == JobStepInstanceState.DONE) {
                doneSteps.put(stepInstance.getStep().getName(), null);
            }
            if (stepInstance.getState() != JobStepInstanceState.RUN) continue;
            runStepsMap.put(stepInstance, stepInstance);
        }
        for (AbstractJobStepInstance stepInstance : this.getSteps()) {
            if (stepInstance.getState() != JobStepInstanceState.READY) continue;
            boolean passed = true;
            Iterator iterator = stepInstance.getStep().getPreviousSteps().iterator();
            while (iterator.hasNext()) {
                JobStep startStep = (JobStep)((Object)iterator.next());
                if (doneSteps.containsKey(startStep.getName())) continue;
                passed = false;
                break;
            }
            if (!passed) continue;
            readySteps.add(stepInstance);
            readyStepsMap.put(stepInstance, stepInstance);
        }
        this._readySteps = readySteps;
        this._readyStepsMap = readyStepsMap;
        this._runStepsMap = runStepsMap;
        return this._readySteps;
    }

    public HashMap<AbstractJobStepInstance, AbstractJobStepInstance> getAllowedReadyStepsMap() {
        if (this._readyStepsMap == null) {
            this.getAllowedReadySteps();
        }
        return this._readyStepsMap;
    }

    public HashMap<AbstractJobStepInstance, AbstractJobStepInstance> getRunStepsMap() {
        if (this._runStepsMap == null) {
            this.getAllowedReadyStepsMap();
        }
        return this._runStepsMap;
    }

    public void clearCaches() {
        this._readySteps = null;
        this._readyStepsMap = null;
        this._runStepsMap = null;
    }
}

