/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.etl.common.metadata.data.job;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.clawiz.core.common.CoreException;
import org.clawiz.core.common.metadata.install.AbstractMetadataNodeInstaller;
import org.clawiz.etl.common.install.job.JobInstaller;
import org.clawiz.etl.common.manager.dataset.AbstractDataSet;
import org.clawiz.etl.common.metadata.data.job.JobPrototype;
import org.clawiz.etl.common.metadata.data.job.step.JobStep;
import org.clawiz.etl.common.metadata.data.job.step.action.AbstractJobStepAction;
import org.clawiz.etl.common.metadata.data.structure.Structure;

public class Job
extends JobPrototype {
    ConcurrentHashMap<Class, ArrayList<AbstractJobStepAction>> loadDataSetClassActionsCache = new ConcurrentHashMap();

    public <T extends AbstractMetadataNodeInstaller> Class<T> getInstallerClass() {
        return JobInstaller.class;
    }

    public JobStep getStep(String stepName) {
        return this.getStep(stepName, true);
    }

    public JobStep getStep(String stepName, boolean throwNotFoundError) {
        JobStep step = (JobStep)this.getSteps().get(stepName);
        if (step != null || !throwNotFoundError) {
            return step;
        }
        throw new CoreException("Step '?' not found in job '?'", new Object[]{stepName, this.getFullName()});
    }

    public <T extends AbstractDataSet> ArrayList<AbstractJobStepAction> getLoadDataSetClassActions(Class<T> dataSetClass) {
        ArrayList<AbstractJobStepAction> result = this.loadDataSetClassActionsCache.get(dataSetClass);
        if (result != null) {
            return result;
        }
        result = new ArrayList();
        Iterator iterator = this.getSteps().iterator();
        while (iterator.hasNext()) {
            JobStep step = (JobStep)((Object)iterator.next());
            Iterator iterator2 = step.getActions().iterator();
            while (iterator2.hasNext()) {
                AbstractJobStepAction action = (AbstractJobStepAction)((Object)iterator2.next());
                for (Structure structure : action.getProcessStructures()) {
                    if (!dataSetClass.getName().equals(structure.getDataSetClassName())) continue;
                    result.add(action);
                }
            }
        }
        this.loadDataSetClassActionsCache.put(dataSetClass, result);
        return result;
    }

    public <T extends AbstractDataSet> ArrayList<AbstractJobStepAction> getLoadDataSetActions(T dataSet) {
        return this.getLoadDataSetClassActions(dataSet.getClass());
    }
}

