/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.etl.common.storage.job;

import org.clawiz.core.common.CoreException;
import org.clawiz.core.common.system.object.AbstractObject;
import org.clawiz.etl.common.storage.job.JobObject;
import org.clawiz.etl.common.storage.job.JobService;

public class JobObjectPrototype
extends AbstractObject {
    private String packageName;
    private String name;
    public JobService service;

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        if (packageName != null && packageName.length() > 250) {
            throw new CoreException("Length of field '?' value cannot be more then ?", new Object[]{"Job.PackageName", "250"});
        }
        this.packageName = packageName;
    }

    public JobObjectPrototype withPackageName(String packageName) {
        this.setPackageName(packageName);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null && name.length() > 128) {
            throw new CoreException("Length of field '?' value cannot be more then ?", new Object[]{"Job.Name", "128"});
        }
        this.name = name;
    }

    public JobObjectPrototype withName(String name) {
        this.setName(name);
        return this;
    }

    public JobService getService() {
        return this.service;
    }

    public void setService(JobService service) {
        this.service = service;
    }

    public void copy(JobObjectPrototype target) {
        target.setPackageName(this.getPackageName());
        target.setName(this.getName());
    }

    public void fillDefaults() {
        if (this.service == null) {
            throw new CoreException("Service must be defined before fill object default values", new Object[0]);
        }
    }

    public void check() {
        if (this.service == null) {
            throw new CoreException("Service must be defined before check object data", new Object[0]);
        }
        this.service.check((JobObject)this);
    }

    public void save() {
        if (this.service == null) {
            throw new CoreException("Service must be defined before save object", new Object[0]);
        }
        this.service.save((JobObject)this);
    }

    public boolean equals(JobObjectPrototype object) {
        return this.isObjectsEquals(this.getPackageName(), object.getPackageName()) && this.isObjectsEquals(this.getName(), object.getName());
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.getPackageName() != null ? this.getPackageName().hashCode() : 0);
        result = result * 31 + (this.getName() != null ? this.getName().hashCode() : 0);
        return result;
    }

    public String toPackageName() {
        return this.getPackageName() + "," + this.getName();
    }
}

