/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.etl.common.storage.job;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.clawiz.core.common.metadata.MetadataBase;
import org.clawiz.core.common.utils.StringUtils;
import org.clawiz.etl.common.metadata.data.job.Job;
import org.clawiz.etl.common.metadata.data.job.step.JobStep;
import org.clawiz.etl.common.storage.job.JobObject;
import org.clawiz.etl.common.storage.job.JobServicePrototype;
import org.clawiz.etl.common.storage.jobstep.JobStepService;

public class JobService
extends JobServicePrototype {
    private static ConcurrentHashMap<String, BigDecimal> _fullNamesCache = new ConcurrentHashMap();
    private static ConcurrentHashMap<BigDecimal, Job> _jobsCache = new ConcurrentHashMap();

    public BigDecimal fullNameToId(String name) {
        if (name == null) {
            return null;
        }
        String[] tokens = StringUtils.splitByLastTokenOccurrence((String)name, (String)"\\.");
        if (tokens.length < 2) {
            return null;
        }
        BigDecimal id = this.packageNameToId(tokens[0], tokens[1]);
        if (id != null) {
            _fullNamesCache.put(name, id);
        }
        return id;
    }

    public Job getJob(BigDecimal jobId) {
        if (jobId == null) {
            return null;
        }
        Job job = _jobsCache.get(jobId);
        if (job != null) {
            return job;
        }
        JobObject jobObject = this.load(jobId);
        if (jobObject == null) {
            this.throwException("Job with id ? not found in database", new Object[]{jobId});
        }
        MetadataBase metadataBase = (MetadataBase)this.getService(MetadataBase.class);
        JobStepService stepService = (JobStepService)this.getService(JobStepService.class);
        job = (Job)metadataBase.getNode(Job.class, jobObject.getPackageName(), jobObject.getName(), true);
        job.setId(jobId);
        Iterator iterator = job.getSteps().iterator();
        while (iterator.hasNext()) {
            JobStep step = (JobStep)((Object)iterator.next());
            BigDecimal id = stepService.jobNameToId(jobId, step.getName());
            if (id == null) {
                this.throwException("Job ? step '?' not registered in database. Attempt to reinstall module", new Object[]{job.getFullName(), step.getName()});
            }
            step.setId(id);
        }
        _jobsCache.put(jobId, job);
        return job;
    }

    public static void clearStaticCaches() {
        _fullNamesCache.clear();
        _jobsCache.clear();
    }

    @Override
    public void save(JobObject processObject) {
        super.save(processObject);
        JobService.clearStaticCaches();
    }

    @Override
    public void delete(BigDecimal id) {
        super.delete(id);
        JobService.clearStaticCaches();
    }
}

