/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.etl.common.storage.job;

import java.math.BigDecimal;
import org.clawiz.core.common.storage.type.TypeService;
import org.clawiz.core.common.system.database.Statement;
import org.clawiz.core.common.system.session.transaction.TransactionAction;
import org.clawiz.core.common.system.session.transaction.TransactionActionType;
import org.clawiz.core.common.system.type.AbstractTypeService;
import org.clawiz.etl.common.storage.job.JobList;
import org.clawiz.etl.common.storage.job.JobObject;
import org.clawiz.etl.common.storage.job.JobService;

public class JobServicePrototype
extends AbstractTypeService<JobObject> {
    private static BigDecimal _typeId;

    public void init() {
        super.init();
        if (_typeId == null && (_typeId = ((TypeService)this.getService(TypeService.class)).packageNameToId("org.clawiz.etl.common.storage", "Job")) == null) {
            this.throwException("Type '?' not registered in database", new Object[]{"org.clawiz.etl.common.storage.Job"});
        }
        this.setTypeId(_typeId);
    }

    public void check(JobObject job) {
        if (job == null) {
            this.throwException("Cannot check null ?", new Object[]{"JobObject"});
        }
        job.fillDefaults();
        if (this.packageNameToId(job.getPackageName(), job.getName(), job.getId()) != null) {
            this.throwException("? '?' already exists", new Object[]{"Job", job.toPackageName()});
        }
    }

    public JobObject create() {
        JobObject job = new JobObject();
        job.setService((JobService)this);
        job.fillDefaults();
        return job;
    }

    public JobObject load(BigDecimal id) {
        Statement statement = this.executeQuery("select package_name, name from cw_etl_jobs where id = ?", new Object[]{id});
        if (!statement.next()) {
            statement.close();
            this.throwException("? with id ? not found in database", new Object[]{"Job", id});
        }
        JobObject result = new JobObject();
        result.setService((JobService)this);
        result.setId(id);
        result.setPackageName(statement.getString(1));
        result.setName(statement.getString(2));
        statement.close();
        return result;
    }

    public JobList loadList(String whereClause, Object ... parameters) {
        return this.loadOrderedList(whereClause, null, parameters);
    }

    public JobList loadOrderedList(String whereClause, String orderByClause, Object ... parameters) {
        JobList result = new JobList();
        Statement statement = this.executeQuery("select id, package_name, name from cw_etl_jobs" + (whereClause != null ? " where " + whereClause : "") + (orderByClause != null ? " order by " + orderByClause : ""), parameters);
        while (statement.next()) {
            JobObject object = new JobObject();
            object.setService((JobService)this);
            object.setId(statement.getBigDecimal(1));
            object.setPackageName(statement.getString(2));
            object.setName(statement.getString(3));
            result.add((Object)object);
        }
        statement.close();
        return result;
    }

    public BigDecimal packageNameToId(String packageName, String name) {
        return this.packageNameToId(packageName, name, null);
    }

    public BigDecimal packageNameToId(String packageName, String name, BigDecimal skipId) {
        if (packageName == null || name == null) {
            return null;
        }
        if (skipId == null) {
            return this.executeQueryBigDecimal("select id from cw_etl_jobs where upper_package_name = ? and upper_name = ?", new Object[]{packageName.toUpperCase(), name.toUpperCase()});
        }
        return this.executeQueryBigDecimal("select id from cw_etl_jobs where upper_package_name = ? and upper_name = ? and id != ?", new Object[]{packageName.toUpperCase(), name.toUpperCase(), skipId});
    }

    public BigDecimal packageNameToId(String packageName, String name, boolean createNewIfNotFound) {
        BigDecimal id = this.packageNameToId(packageName, name, null);
        if (id != null || !createNewIfNotFound) {
            return id;
        }
        JobObject object = this.create();
        object.setPackageName(packageName);
        object.setName(name);
        this.save(object);
        return object.getId();
    }

    public String idToPackageName(BigDecimal id) {
        if (id == null) {
            return null;
        }
        Statement statement = this.executeQuery("select package_name, name from cw_etl_jobs where id = ?", new Object[]{id});
        if (!statement.next()) {
            statement.close();
            return null;
        }
        JobObject object = new JobObject();
        object.setService((JobService)this);
        object.setId(id);
        object.setPackageName(statement.getString(1));
        object.setName(statement.getString(2));
        statement.close();
        return object.toPackageName();
    }

    public String idToString(BigDecimal id) {
        return this.idToPackageName(id);
    }

    public String objectToString(JobObject jobObject) {
        return jobObject.toPackageName();
    }

    protected void saveAudit(TransactionAction transactionAction, JobObject oldJobObject, JobObject newJobObject) {
        JobObject o = oldJobObject != null ? oldJobObject : new JobObject();
        JobObject n = newJobObject != null ? newJobObject : new JobObject();
        this.executeUpdate("insert into a_cw_etl_jobs (scn, action_type, id , o_package_name, o_upper_package_name, o_name, o_upper_name, n_package_name, n_upper_package_name, n_name, n_upper_name) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{transactionAction.getScn(), transactionAction.getType().toString(), o.getId() != null ? o.getId() : n.getId(), o.getPackageName(), o.getPackageName() != null ? o.getPackageName().toUpperCase() : null, o.getName(), o.getName() != null ? o.getName().toUpperCase() : null, n.getPackageName(), n.getPackageName() != null ? n.getPackageName().toUpperCase() : null, n.getName(), n.getName() != null ? n.getName().toUpperCase() : null});
    }

    public void save(JobObject job) {
        TransactionAction transactionAction;
        JobObject oldJob;
        if (job == null) {
            this.throwException("Cannot save NULL ?", new Object[]{"JobObject"});
        }
        if (job.getService() == null) {
            job.setService((JobService)this);
        }
        this.check(job);
        if (job.getId() == null) {
            job.setId(this.getObjectService().createObject(this.getTypeId()));
            oldJob = null;
            transactionAction = this.getSession().newObjectTransactionAction(TransactionActionType.NEW, job.getId());
            this.executeUpdate("insert into cw_etl_jobs( id, package_name, upper_package_name, name, upper_name ) values(?, ?, ?, ?, ?)", new Object[]{job.getId(), job.getPackageName(), job.getPackageName() != null ? job.getPackageName().toUpperCase() : null, job.getName(), job.getName() != null ? job.getName().toUpperCase() : null});
        } else {
            oldJob = this.load(job.getId());
            if (oldJob.equals(job)) {
                return;
            }
            transactionAction = this.getSession().newObjectTransactionAction(TransactionActionType.CHANGE, job.getId());
            this.executeUpdate("update cw_etl_jobs set package_name = ?, upper_package_name = ?, name = ?, upper_name = ? where id = ?", new Object[]{job.getPackageName(), job.getPackageName() != null ? job.getPackageName().toUpperCase() : null, job.getName(), job.getName() != null ? job.getName().toUpperCase() : null, job.getId()});
        }
        this.saveAudit(transactionAction, oldJob, job);
    }

    public void delete(BigDecimal id) {
        JobObject oldJobObject = this.load(id);
        TransactionAction transactionAction = this.getSession().newObjectTransactionAction(TransactionActionType.DELETE, id);
        this.saveAudit(transactionAction, oldJobObject, null);
        this.getObjectService().deleteObject(id);
        this.executeUpdate("delete from cw_etl_jobs where id = ?", new Object[]{id});
    }
}

