/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.etl.common.storage.jobstep;

import java.math.BigDecimal;
import org.clawiz.core.common.CoreException;
import org.clawiz.core.common.system.object.AbstractObject;
import org.clawiz.etl.common.storage.jobstep.JobStepObject;
import org.clawiz.etl.common.storage.jobstep.JobStepService;

public class JobStepObjectPrototype
extends AbstractObject {
    private BigDecimal jobId;
    private String name;
    private String description;
    private Boolean active;
    public JobStepService service;

    public BigDecimal getJobId() {
        return this.jobId;
    }

    public void setJobId(BigDecimal jobId) {
        this.jobId = jobId;
    }

    public JobStepObjectPrototype withJobId(BigDecimal jobId) {
        this.setJobId(jobId);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null && name.length() > 128) {
            throw new CoreException("Length of field '?' value cannot be more then ?", new Object[]{"JobStep.Name", "128"});
        }
        this.name = name;
    }

    public JobStepObjectPrototype withName(String name) {
        this.setName(name);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description != null && description.length() > 512) {
            throw new CoreException("Length of field '?' value cannot be more then ?", new Object[]{"JobStep.Description", "512"});
        }
        this.description = description;
    }

    public JobStepObjectPrototype withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Boolean isActive() {
        return this.active != null ? this.active : false;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setActive(boolean active) {
        this.active = new Boolean(active);
    }

    public JobStepObjectPrototype withActive(Boolean active) {
        this.setActive(active);
        return this;
    }

    public JobStepObjectPrototype withActive(boolean active) {
        this.setActive(active);
        return this;
    }

    public JobStepService getService() {
        return this.service;
    }

    public void setService(JobStepService service) {
        this.service = service;
    }

    public void copy(JobStepObjectPrototype target) {
        target.setJobId(this.getJobId());
        target.setName(this.getName());
        target.setDescription(this.getDescription());
        target.setActive(this.isActive());
    }

    public void fillDefaults() {
        if (this.service == null) {
            throw new CoreException("Service must be defined before fill object default values", new Object[0]);
        }
    }

    public void check() {
        if (this.service == null) {
            throw new CoreException("Service must be defined before check object data", new Object[0]);
        }
        this.service.check((JobStepObject)this);
    }

    public void save() {
        if (this.service == null) {
            throw new CoreException("Service must be defined before save object", new Object[0]);
        }
        this.service.save((JobStepObject)this);
    }

    public boolean equals(JobStepObjectPrototype object) {
        return this.isObjectsEquals(this.getJobId(), object.getJobId()) && this.isObjectsEquals(this.getName(), object.getName()) && this.isObjectsEquals(this.getDescription(), object.getDescription()) && this.isObjectsEquals(this.isActive(), object.isActive());
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.getJobId() != null ? this.getJobId().hashCode() : 0);
        result = result * 31 + (this.getName() != null ? this.getName().hashCode() : 0);
        result = result * 31 + (this.getDescription() != null ? this.getDescription().hashCode() : 0);
        result = result * 31 + (this.isActive() != null ? this.isActive().hashCode() : 0);
        return result;
    }

    public String toJobName() {
        return this.service.getObjectService().idToString(this.getJobId()) + "," + this.getName();
    }
}

