/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.etl.common.storage.jobstep;

import java.math.BigDecimal;
import org.clawiz.core.common.storage.type.TypeService;
import org.clawiz.core.common.system.database.Statement;
import org.clawiz.core.common.system.session.transaction.TransactionAction;
import org.clawiz.core.common.system.session.transaction.TransactionActionType;
import org.clawiz.core.common.system.type.AbstractTypeService;
import org.clawiz.etl.common.storage.jobstep.JobStepList;
import org.clawiz.etl.common.storage.jobstep.JobStepObject;
import org.clawiz.etl.common.storage.jobstep.JobStepService;

public class JobStepServicePrototype
extends AbstractTypeService<JobStepObject> {
    private static BigDecimal _typeId;

    public void init() {
        super.init();
        if (_typeId == null && (_typeId = ((TypeService)this.getService(TypeService.class)).packageNameToId("org.clawiz.etl.common.storage", "JobStep")) == null) {
            this.throwException("Type '?' not registered in database", new Object[]{"org.clawiz.etl.common.storage.JobStep"});
        }
        this.setTypeId(_typeId);
    }

    public void check(JobStepObject jobStep) {
        if (jobStep == null) {
            this.throwException("Cannot check null ?", new Object[]{"JobStepObject"});
        }
        jobStep.fillDefaults();
        if (this.jobNameToId(jobStep.getJobId(), jobStep.getName(), jobStep.getId()) != null) {
            this.throwException("? '?' already exists", new Object[]{"JobStep", jobStep.toJobName()});
        }
    }

    public JobStepObject create() {
        JobStepObject jobStep = new JobStepObject();
        jobStep.setService((JobStepService)this);
        jobStep.fillDefaults();
        return jobStep;
    }

    public JobStepObject load(BigDecimal id) {
        Statement statement = this.executeQuery("select job_id, name, description, active from cw_etl_job_steps where id = ?", new Object[]{id});
        if (!statement.next()) {
            statement.close();
            this.throwException("? with id ? not found in database", new Object[]{"JobStep", id});
        }
        JobStepObject result = new JobStepObject();
        result.setService((JobStepService)this);
        result.setId(id);
        result.setJobId(statement.getBigDecimal(1));
        result.setName(statement.getString(2));
        result.setDescription(statement.getString(3));
        result.setActive("T".equals(statement.getString(4)));
        statement.close();
        return result;
    }

    public JobStepList loadList(String whereClause, Object ... parameters) {
        return this.loadOrderedList(whereClause, null, parameters);
    }

    public JobStepList loadOrderedList(String whereClause, String orderByClause, Object ... parameters) {
        JobStepList result = new JobStepList();
        Statement statement = this.executeQuery("select id, job_id, name, description, active from cw_etl_job_steps" + (whereClause != null ? " where " + whereClause : "") + (orderByClause != null ? " order by " + orderByClause : ""), parameters);
        while (statement.next()) {
            JobStepObject object = new JobStepObject();
            object.setService((JobStepService)this);
            object.setId(statement.getBigDecimal(1));
            object.setJobId(statement.getBigDecimal(2));
            object.setName(statement.getString(3));
            object.setDescription(statement.getString(4));
            object.setActive("T".equals(statement.getString(5)));
            result.add((Object)object);
        }
        statement.close();
        return result;
    }

    public BigDecimal jobNameToId(BigDecimal jobId, String name) {
        return this.jobNameToId(jobId, name, null);
    }

    public BigDecimal jobNameToId(BigDecimal jobId, String name, BigDecimal skipId) {
        if (jobId == null || name == null) {
            return null;
        }
        if (skipId == null) {
            return this.executeQueryBigDecimal("select id from cw_etl_job_steps where job_id = ? and upper_name = ?", new Object[]{jobId, name.toUpperCase()});
        }
        return this.executeQueryBigDecimal("select id from cw_etl_job_steps where job_id = ? and upper_name = ? and id != ?", new Object[]{jobId, name.toUpperCase(), skipId});
    }

    public BigDecimal jobNameToId(BigDecimal jobId, String name, boolean createNewIfNotFound) {
        BigDecimal id = this.jobNameToId(jobId, name, null);
        if (id != null || !createNewIfNotFound) {
            return id;
        }
        JobStepObject object = this.create();
        object.setJobId(jobId);
        object.setName(name);
        this.save(object);
        return object.getId();
    }

    public String idToJobName(BigDecimal id) {
        if (id == null) {
            return null;
        }
        Statement statement = this.executeQuery("select job_id, name from cw_etl_job_steps where id = ?", new Object[]{id});
        if (!statement.next()) {
            statement.close();
            return null;
        }
        JobStepObject object = new JobStepObject();
        object.setService((JobStepService)this);
        object.setId(id);
        object.setJobId(statement.getBigDecimal(1));
        object.setName(statement.getString(2));
        statement.close();
        return object.toJobName();
    }

    public String idToString(BigDecimal id) {
        return this.idToJobName(id);
    }

    public String objectToString(JobStepObject jobStepObject) {
        return jobStepObject.toJobName();
    }

    protected void saveAudit(TransactionAction transactionAction, JobStepObject oldJobStepObject, JobStepObject newJobStepObject) {
        JobStepObject o = oldJobStepObject != null ? oldJobStepObject : new JobStepObject();
        JobStepObject n = newJobStepObject != null ? newJobStepObject : new JobStepObject();
        this.executeUpdate("insert into a_cw_etl_job_steps (scn, action_type, id , o_job_id, o_name, o_upper_name, o_description, o_active, n_job_id, n_name, n_upper_name, n_description, n_active) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{transactionAction.getScn(), transactionAction.getType().toString(), o.getId() != null ? o.getId() : n.getId(), o.getJobId(), o.getName(), o.getName() != null ? o.getName().toUpperCase() : null, o.getDescription(), o.isActive() != false ? "T" : "F", n.getJobId(), n.getName(), n.getName() != null ? n.getName().toUpperCase() : null, n.getDescription(), n.isActive() != false ? "T" : "F"});
    }

    public void save(JobStepObject jobStep) {
        TransactionAction transactionAction;
        JobStepObject oldJobStep;
        if (jobStep == null) {
            this.throwException("Cannot save NULL ?", new Object[]{"JobStepObject"});
        }
        if (jobStep.getService() == null) {
            jobStep.setService((JobStepService)this);
        }
        this.check(jobStep);
        if (jobStep.getId() == null) {
            jobStep.setId(this.getObjectService().createObject(this.getTypeId()));
            oldJobStep = null;
            transactionAction = this.getSession().newObjectTransactionAction(TransactionActionType.NEW, jobStep.getId());
            this.executeUpdate("insert into cw_etl_job_steps( id, job_id, name, upper_name, description, active ) values(?, ?, ?, ?, ?, ?)", new Object[]{jobStep.getId(), jobStep.getJobId(), jobStep.getName(), jobStep.getName() != null ? jobStep.getName().toUpperCase() : null, jobStep.getDescription(), jobStep.isActive() != false ? "T" : "F"});
            if (jobStep.getJobId() != null) {
                this.getObjectService().setLink(jobStep.getJobId(), jobStep.getId());
            }
        } else {
            oldJobStep = this.load(jobStep.getId());
            if (oldJobStep.equals(jobStep)) {
                return;
            }
            transactionAction = this.getSession().newObjectTransactionAction(TransactionActionType.CHANGE, jobStep.getId());
            this.executeUpdate("update cw_etl_job_steps set job_id = ?, name = ?, upper_name = ?, description = ?, active = ? where id = ?", new Object[]{jobStep.getJobId(), jobStep.getName(), jobStep.getName() != null ? jobStep.getName().toUpperCase() : null, jobStep.getDescription(), jobStep.isActive() != false ? "T" : "F", jobStep.getId()});
            this.getObjectService().changeLinkParent(oldJobStep.getJobId(), jobStep.getJobId(), jobStep.getId());
        }
        this.saveAudit(transactionAction, oldJobStep, jobStep);
    }

    public void delete(BigDecimal id) {
        JobStepObject oldJobStepObject = this.load(id);
        TransactionAction transactionAction = this.getSession().newObjectTransactionAction(TransactionActionType.DELETE, id);
        this.saveAudit(transactionAction, oldJobStepObject, null);
        this.getObjectService().deleteObject(id);
        if (oldJobStepObject.getJobId() != null) {
            this.getObjectService().deleteLink(oldJobStepObject.getJobId(), id);
        }
        this.executeUpdate("delete from cw_etl_job_steps where id = ?", new Object[]{id});
    }
}

