package org.clawiz.ui.common.language.structure;

/*Generated by MPS */

import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.LinkedList;

public enum CollectionDirection {
  horizontal("horizontal", "HORIZONTAL"),
  vertical("vertical", "VERTICAL");

  private final String myName;
  public String getName() {
    return myName;
  }
  private final String myValue;
  private CollectionDirection(String name, String value) {
    myName = name;
    myValue = value;
  }
  public String getValue() {
    return myValue;
  }
  public String getValueAsString() {
    return myValue;
  }
  public static List<CollectionDirection> getConstants() {
    List<CollectionDirection> list = ListSequence.fromList(new LinkedList<CollectionDirection>());
    ListSequence.fromList(list).addElement(CollectionDirection.horizontal);
    ListSequence.fromList(list).addElement(CollectionDirection.vertical);
    return list;
  }
  public static CollectionDirection getDefault() {
    return null;
  }
  public static CollectionDirection parseValue(String value) {
    if (value == null) {
      return CollectionDirection.getDefault();
    }
    if (value.equals(CollectionDirection.horizontal.getValueAsString())) {
      return CollectionDirection.horizontal;
    }
    if (value.equals(CollectionDirection.vertical.getValueAsString())) {
      return CollectionDirection.vertical;
    }
    return CollectionDirection.getDefault();
  }
}
