/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.portal.common;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.clawiz.core.common.system.service.NotInitializeService;
import org.clawiz.core.common.utils.RandomGUID;
import org.clawiz.portal.common.AbstractContext;
import org.clawiz.portal.common.PortalPortContext;
import org.clawiz.portal.common.PortalSession;
import org.clawiz.portal.common.engine.EngineContext;
import org.clawiz.portal.common.site.AbstractSiteContext;

public class PortalContext
extends AbstractContext {
    public static final String CONFIG_PORT = "port";
    public static final int DEFAULT_PORT = 80;
    @NotInitializeService
    private EngineContext engineContext;
    ArrayList<PortalPortContext> ports = new ArrayList();
    private int portsCount = 0;
    private ConcurrentHashMap<String, PortalSession> sessionsCache = new ConcurrentHashMap();

    public EngineContext getEngineContext() {
        return this.engineContext;
    }

    public void setEngineContext(EngineContext engineContext) {
        this.engineContext = engineContext;
    }

    public PortalPortContext addSite(AbstractSiteContext site) {
        if (site.getHttpPort() == 0) {
            site.setHttpPort(80);
        }
        PortalPortContext portContext = null;
        for (PortalPortContext port : this.ports) {
            if (port.getPort() != site.getHttpPort()) continue;
            portContext = port;
            break;
        }
        if (portContext == null) {
            portContext = (PortalPortContext)this.getService(PortalPortContext.class, PortalPortContext.class.getName() + ":" + new RandomGUID().toString());
            portContext.setPortalContext(this);
            portContext.setPort(site.getHttpPort());
            this.ports.add(portContext);
        }
        portContext.addSite(site);
        return portContext;
    }

    public ArrayList<PortalPortContext> getPorts() {
        return this.ports;
    }

    public String getName() {
        return this.engineContext != null ? this.engineContext.getEngineClassName() : ((Object)((Object)this)).toString();
    }

    public String getSessionIdCookieName() {
        return "CWSESSIONID";
    }

    public PortalSession getSession(String id) {
        return id != null ? this.sessionsCache.get(id) : null;
    }
}

