/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.portal.common.engine.jetty.handler;

import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.clawiz.core.common.system.service.Service;
import org.clawiz.core.common.system.session.Session;
import org.clawiz.core.common.utils.StringUtils;
import org.clawiz.portal.common.PortalSession;
import org.clawiz.portal.common.engine.jetty.JettyHttpRequestContext;
import org.clawiz.portal.common.engine.jetty.JettyHttpResponseContext;
import org.clawiz.portal.common.servlet.FilesServletContext;
import org.clawiz.portal.common.servlet.ServletContext;
import org.clawiz.portal.common.servlet.http.AbstractHttpServlet;
import org.clawiz.portal.common.servlet.http.error.AbstractHttpErrorHandlerServlet;
import org.clawiz.portal.common.servlet.http.error.DefaultHttpErrorHandlerServlet;
import org.clawiz.portal.common.servlet.http.protocol.Header;
import org.clawiz.portal.common.servlet.http.protocol.HttpResponseStatus;
import org.clawiz.portal.common.site.AbstractSiteContext;
import org.clawiz.portal.common.site.LocaleContext;
import org.clawiz.portal.common.site.application.AbstractApplicationContext;
import org.eclipse.jetty.server.Request;

public class JettySiteServletHandlerService
extends Service {
    private static ConcurrentHashMap<Session, BigDecimal> sessionCountersCache = new ConcurrentHashMap();

    private PortalSession newSession(AbstractSiteContext siteContext) {
        PortalSession portalSession = siteContext.newSession();
        if (siteContext.getSiteAutoLoginUserName() != null) {
            portalSession.login(siteContext.getSiteAutoLoginUserName(), siteContext.getSiteAutoLoginUserPassword());
        }
        return portalSession;
    }

    protected PortalSession getPortalSession(HttpServletRequest httpServletRequest, AbstractSiteContext siteContext, ServletContext servletContext, JettyHttpResponseContext responseContext) {
        PortalSession portalSession;
        boolean sessionAsParameter;
        String sessionId = httpServletRequest.getParameter(siteContext.getSessionIdParameterName());
        boolean bl = sessionAsParameter = sessionId != null;
        if (sessionId == null && httpServletRequest.getCookies() != null) {
            for (Cookie cookie : httpServletRequest.getCookies()) {
                if (!siteContext.getSessionIdParameterName().equals(cookie.getName())) continue;
                sessionId = cookie.getValue();
                break;
            }
        }
        if (servletContext != null && servletContext.isSessionIdRequired() && StringUtils.isEmpty((String)sessionId)) {
            this.throwException("Parameter '?' must be defined", new Object[]{siteContext.getSessionIdParameterName()});
        }
        if ((portalSession = siteContext.getSession(sessionId)) == null) {
            if (sessionId != null) {
                if (sessionAsParameter) {
                    this.throwException("Wrong session id '?'", new Object[]{sessionId});
                }
                this.logDebug("Session id '" + sessionId + "' not found in sessions cache");
            }
            portalSession = this.newSession(siteContext);
            responseContext.setCookie(portalSession.getSessionCookie());
        }
        return portalSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementSessionCounter(Session session) {
        Session session2 = session;
        synchronized (session2) {
            BigDecimal counter = sessionCountersCache.get(session);
            sessionCountersCache.put(session, counter != null ? new BigDecimal(counter.intValue() + 1) : new BigDecimal(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementSessionCounter(Session session) {
        Session session2 = session;
        synchronized (session2) {
            BigDecimal counter = sessionCountersCache.get(session);
            if (counter == null || counter.intValue() <= 1) {
                sessionCountersCache.remove(session);
                session.getConnection().close();
            } else {
                sessionCountersCache.put(session, new BigDecimal(counter.intValue() - 1));
            }
        }
    }

    private void callServlet(AbstractSiteContext siteContext, String target, LocaleContext localeContext, ServletContext servletContext, Request jettyRequest, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, JettyHttpRequestContext requestContext, JettyHttpResponseContext responseContext, HttpResponseStatus errorStatus, String message) {
        if (servletContext == null) {
            return;
        }
        if (localeContext == null) {
            localeContext = siteContext.getDefaultLocale();
        }
        requestContext.setResponse(responseContext);
        responseContext.setRequest(requestContext);
        requestContext.setHttpServletRequest(httpServletRequest);
        requestContext.setJettyRequest(jettyRequest);
        requestContext.setPath(siteContext.removeLocaleFromPath(target, localeContext));
        responseContext.setHttpServletResponse(httpServletResponse);
        requestContext.setServletContext(servletContext);
        requestContext.setLocaleContext(localeContext);
        requestContext.prepare();
        responseContext.prepare();
        AbstractHttpServlet servlet = (AbstractHttpServlet)((Object)requestContext.getPortalSession().lockServlet(servletContext));
        this.incrementSessionCounter(servlet.getSession());
        try {
            if (errorStatus == null) {
                servlet.service(requestContext);
            } else {
                ((AbstractHttpErrorHandlerServlet)servlet).doError(requestContext, errorStatus, message);
                servlet.rollback();
            }
            servlet.commit();
            this.decrementSessionCounter(servlet.getSession());
        }
        catch (Exception e) {
            servlet.rollback();
            this.decrementSessionCounter(servlet.getSession());
            throw e;
        }
        finally {
            servlet.releaseLock();
        }
        httpServletResponse.setContentType(responseContext.getContentType() + ";charset=" + responseContext.getCharset());
        httpServletResponse.setStatus(responseContext.getStatus().code());
        for (Cookie cookie : responseContext.getCookies().values()) {
            httpServletResponse.addCookie(cookie);
        }
        for (Header header : responseContext.getHeaders().values()) {
            httpServletResponse.addHeader(header.getName(), header.getValue());
        }
        if (siteContext.getAccessControlAllowOrigin() != null) {
            httpServletResponse.addHeader("Access-Control-Allow-Origin", siteContext.getAccessControlAllowOrigin());
        }
        try {
            PrintWriter out = httpServletResponse.getWriter();
            out.println(responseContext.getBuffer().toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        jettyRequest.setHandled(true);
    }

    public void handleError(AbstractSiteContext siteContext, String target, Request jettyRequest, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, JettyHttpRequestContext requestContext, JettyHttpResponseContext responseContext, HttpResponseStatus errorStatus, String message) {
        LocaleContext localeContext = siteContext.getLocaleByPath(target);
        String applicationPath = null;
        ServletContext handlerContext = null;
        String path = siteContext.removeLocaleFromPath(target, localeContext);
        for (AbstractApplicationContext context : siteContext.getApplicationContexts()) {
            if (!StringUtils.isLike((String)path, (String)(context.getPath() + "*")) && !StringUtils.isLike((String)path, (String)(context.getPath() + "/*")) && !StringUtils.isLike((String)path, (String)("/" + context.getPath() + "*")) && !StringUtils.isLike((String)path, (String)("/" + context.getPath() + "/*")) || applicationPath != null && (context.getPath() == null || context.getPath().length() <= applicationPath.length())) continue;
            applicationPath = context.getPath();
            handlerContext = context.getHttpErrorHandler();
        }
        if (handlerContext == null) {
            handlerContext = new ServletContext();
            handlerContext.setServletClass(DefaultHttpErrorHandlerServlet.class, this.getSession());
        }
        this.callServlet(siteContext, target, localeContext, handlerContext, jettyRequest, httpServletRequest, httpServletResponse, requestContext, responseContext, errorStatus, message);
        jettyRequest.setHandled(true);
    }

    protected String encodeAttributeValueQuotes(String str) {
        return str.replace("\"", "&quot;");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(AbstractSiteContext siteContext, String target, Request jettyRequest, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        LocaleContext localeContext = siteContext.getLocaleByPath(target);
        ServletContext servletContext = siteContext.getServletContextByPath(target, localeContext);
        if (servletContext == null) {
            return;
        }
        if (servletContext instanceof FilesServletContext) {
            return;
        }
        JettyHttpResponseContext responseContext = new JettyHttpResponseContext();
        PortalSession portalSession = null;
        try {
            JettyHttpRequestContext requestContext = new JettyHttpRequestContext();
            portalSession = this.getPortalSession(httpServletRequest, siteContext, servletContext, responseContext);
            requestContext.setPortalSession(portalSession);
            this.callServlet(siteContext, target, localeContext, servletContext, jettyRequest, httpServletRequest, httpServletResponse, requestContext, responseContext, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.rollback();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            JettyHttpRequestContext errorRequestContext = new JettyHttpRequestContext();
            JettyHttpResponseContext errorResponseContext = new JettyHttpResponseContext();
            errorRequestContext.setPortalSession(portalSession != null ? portalSession : this.newSession(siteContext));
            this.handleError(siteContext, target, jettyRequest, httpServletRequest, httpServletResponse, errorRequestContext, errorResponseContext, HttpResponseStatus.INTERNAL_SERVER_ERROR, e.getMessage() != null ? e.getMessage() : e.toString());
        }
        finally {
            if (portalSession != null) {
                // empty if block
            }
        }
    }
}

