/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.portal.common.engine.netty.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.stream.ChunkedWriteHandler;
import org.clawiz.core.common.Core;
import org.clawiz.core.common.system.logger.Logger;
import org.clawiz.portal.common.PortalPortContext;
import org.clawiz.portal.common.engine.netty.http.NettyHttpServerHandler;

public class NettyServerHttpInitializer
extends ChannelInitializer<SocketChannel> {
    PortalPortContext portContext;
    Logger logger;

    public PortalPortContext getPortContext() {
        return this.portContext;
    }

    public void setPortContext(PortalPortContext portContext) {
        this.portContext = portContext;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Core.getLogger(((Object)((Object)this)).getClass());
        }
        return this.logger;
    }

    private void logDebug(String msg) {
        this.getLogger().debug(msg);
    }

    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline p = ch.pipeline();
        NettyHttpServerHandler httpServerHandler = new NettyHttpServerHandler();
        httpServerHandler.setPortContext(this.portContext);
        p.addLast(new ChannelHandler[]{new HttpServerCodec()});
        p.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
        p.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        p.addLast(new ChannelHandler[]{httpServerHandler});
    }
}

