/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.portal.common.servlet.http;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.clawiz.portal.common.servlet.AbstractServlet;
import org.clawiz.portal.common.servlet.ServletSecureMode;
import org.clawiz.portal.common.servlet.http.api.response.ApiResponseContext;
import org.clawiz.portal.common.servlet.http.html.datamodel.AbstractDataModel;
import org.clawiz.portal.common.servlet.http.html.datamodel.ApplicationDataModel;
import org.clawiz.portal.common.servlet.http.html.datamodel.SiteDataModel;
import org.clawiz.portal.common.servlet.http.html.datamodel.UserDataModel;
import org.clawiz.portal.common.servlet.http.protocol.AbstractHttpRequestContext;
import org.clawiz.portal.common.servlet.http.protocol.HttpResponseStatus;

public class AbstractHttpServlet
extends AbstractServlet {
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_TRACE = "TRACE";
    public static final String HEADER_IFMODSINCE = "If-Modified-Since";
    public static final String HEADER_LASTMOD = "Last-Modified";
    public static final String COOKIE_REDIRECT_AFTER_LOGIN = "CLAWIZ_REDIRECT_AFTER_LOGIN";
    public static final String CONTENT_TYPE_MESSAGEHTTP = "message/http";
    public static final String CONTENT_TYPE_TEXTHTML = "text/html";
    private static final Gson gson = new Gson();

    public void doGet(AbstractHttpRequestContext context) {
        this.throwException("Method GET not implemented", new Object[0]);
    }

    public void doHead(AbstractHttpRequestContext context) {
        this.throwException("Method HEAD not implemented", new Object[0]);
    }

    public void doPost(AbstractHttpRequestContext context) {
        this.throwException("Method POST not implemented", new Object[0]);
    }

    public void doPut(AbstractHttpRequestContext context) {
        this.throwException("Method PUT not implemented", new Object[0]);
    }

    public void doDelete(AbstractHttpRequestContext context) {
        this.throwException("Method DELETE not implemented", new Object[0]);
    }

    public void doOptions(AbstractHttpRequestContext context) {
        this.throwException("Method OPTIONS not implemented", new Object[0]);
    }

    public void doTrace(AbstractHttpRequestContext context) {
        this.throwException("Method TRACE not implemented", new Object[0]);
    }

    public void doPatch(AbstractHttpRequestContext context) {
        this.throwException("Method PATCH not implemented", new Object[0]);
    }

    public void doConnect(AbstractHttpRequestContext context) {
        this.throwException("Method CONNECT not implemented", new Object[0]);
    }

    protected boolean checkSecure(AbstractHttpRequestContext context) {
        if (this.getSecureMode() == ServletSecureMode.REGISTERED_USERS && !context.getPortalSession().isRegistered()) {
            context.getResponse().setCookieValue(COOKIE_REDIRECT_AFTER_LOGIN, context.getUri());
            this.sendApplicationRedirect(context, context.getSiteContext().getLoginPath());
            return false;
        }
        return true;
    }

    public void service(AbstractHttpRequestContext context) {
        if (!this.checkSecure(context)) {
            return;
        }
        switch (context.getMethod()) {
            case GET: {
                this.doGet(context);
                break;
            }
            case POST: {
                this.doPost(context);
                break;
            }
            case PUT: {
                this.doPut(context);
                break;
            }
            case HEAD: {
                this.doHead(context);
                break;
            }
            case DELETE: {
                this.doDelete(context);
                break;
            }
            case OPTIONS: {
                this.doOptions(context);
                break;
            }
            case TRACE: {
                this.doTrace(context);
                break;
            }
            case PATCH: {
                this.doPatch(context);
                break;
            }
            case CONNECT: {
                this.doConnect(context);
                break;
            }
            default: {
                this.throwException("HTTP method '?' not implemented", new Object[]{context.getMethod().toString()});
            }
        }
    }

    public void write(AbstractHttpRequestContext context, String line) {
        context.write(line);
    }

    public void write(AbstractHttpRequestContext context, ApiResponseContext apiResponseContext) {
        context.write(apiResponseContext.toJson().toString());
    }

    public void writeln(AbstractHttpRequestContext context, String line) {
        context.write(line);
        context.write("\n");
    }

    protected <T extends AbstractDataModel> T getTemplateDataModel(AbstractHttpRequestContext requestContext, Class<T> clazz) {
        AbstractDataModel data = null;
        try {
            data = (AbstractDataModel)clazz.newInstance();
            UserDataModel user = new UserDataModel();
            data.setUser(user);
            user.setDisplayName(this.getSession().getUserName());
            user.setRegistered(this.getSession().isRegistered());
            SiteDataModel site = new SiteDataModel();
            site.setLanguage(requestContext.getLanguage());
            data.setSite(site);
            ApplicationDataModel application = new ApplicationDataModel();
            if (requestContext != null && requestContext.getServletContext() != null && requestContext.getServletContext().getApplicationContext() != null) {
                application.setPath(requestContext.getServletContext().getApplicationContext().getPath());
                data.setApplication(application);
            }
        }
        catch (Exception e) {
            this.throwException("Cannot create portal data instance for '?'", new Object[]{clazz});
        }
        return (T)data;
    }

    protected void sendApplicationRedirect(AbstractHttpRequestContext context, String path) {
        context.getResponse().setHeader("Location", context.getServletContext().getApplicationContext().addApplicationPath(path));
        context.getResponse().setStatus(HttpResponseStatus.FOUND);
    }

    protected void sendExternalRedirect(AbstractHttpRequestContext context, String url) {
        context.getResponse().setHeader("Location", url);
        context.getResponse().setStatus(HttpResponseStatus.FOUND);
    }

    public <T> T fromJson(String json, Class<T> clazz) {
        return (T)gson.fromJson(json, clazz);
    }

    public JsonObject fromJson(String json) {
        return ((JsonElement)gson.fromJson(json, JsonElement.class)).getAsJsonObject();
    }

    public String toJson(Object object) {
        return gson.toJson(object);
    }
}

