/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.portal.common.servlet.http.error;

import com.google.gson.JsonObject;
import org.clawiz.core.common.utils.StringUtils;
import org.clawiz.portal.common.servlet.http.error.AbstractHttpErrorHandlerServlet;
import org.clawiz.portal.common.servlet.http.error.ErrorDataModel;
import org.clawiz.portal.common.servlet.http.protocol.AbstractHttpRequestContext;
import org.clawiz.portal.common.servlet.http.protocol.HttpResponseStatus;

public class DefaultHttpErrorHandlerServlet
extends AbstractHttpErrorHandlerServlet {
    protected boolean isApiCall(AbstractHttpRequestContext context) {
        String path = context.getPath();
        return path != null && path.length() > 4 && path.substring(0, 5).equalsIgnoreCase("/api/");
    }

    protected void writeJsonResponse(AbstractHttpRequestContext context, HttpResponseStatus status, String message) {
        if (status == HttpResponseStatus.NOT_FOUND) {
            return;
        }
        JsonObject response = new JsonObject();
        response.addProperty("status", "ERROR");
        response.addProperty("message", message);
        context.write(response.toString());
        context.getResponse().setStatus(HttpResponseStatus.OK);
    }

    protected void writeHtmlResponse(AbstractHttpRequestContext context, HttpResponseStatus status, String message) {
        ErrorDataModel dataModel = this.getErrorDataModel(context, status, message, ErrorDataModel.class);
        context.write("\n<html>\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html;charset=ISO-8859-1\"/>\n<title>Error " + dataModel.error.code + " </title>\n" + "</head>\n" + "<body>\n" + "<h2>HTTP ERROR: " + dataModel.error.code + "</h2>\n" + "<p>Problem accessing " + context.getPath() + ". Reason:\n" + "<pre>    " + dataModel.error.reason + "</pre></p>\n" + (!StringUtils.isEmpty((String)message) ? "<p>Error message:\n<pre>    " + message + "</pre></p>" : "") + "<hr />Powered by org.clawiz.Portal<hr/>\n" + "</body>\n" + "</html>");
    }

    @Override
    public void doError(AbstractHttpRequestContext context, HttpResponseStatus status, String message) {
        context.getResponse().setStatus(status);
        context.getResponse().clearBuffer();
        if (this.isApiCall(context)) {
            this.writeJsonResponse(context, status, message);
        } else {
            this.writeHtmlResponse(context, status, message);
        }
    }
}

