/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.portal.common.servlet.http.html.freemarker;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.clawiz.core.common.Core;
import org.clawiz.portal.common.servlet.http.AbstractHttpServlet;
import org.clawiz.portal.common.servlet.http.html.freemarker.FreemarkerProcessContext;
import org.clawiz.portal.common.servlet.http.protocol.AbstractHttpRequestContext;

public class AbstractFreemarkerHttpServlet
extends AbstractHttpServlet {
    private static final Configuration _configuration = new Configuration(Configuration.VERSION_2_3_21);
    private static Configuration configuration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration getConfiguration() {
        if (configuration == null) {
            Configuration configuration = _configuration;
            synchronized (configuration) {
                try {
                    ClassTemplateLoader ctl = new ClassTemplateLoader(Core.class, "/");
                    TemplateLoader[] loaders = new TemplateLoader[]{ctl};
                    MultiTemplateLoader mtl = new MultiTemplateLoader(loaders);
                    _configuration.setTemplateLoader((TemplateLoader)mtl);
                    _configuration.setDefaultEncoding("UTF-8");
                    _configuration.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                AbstractFreemarkerHttpServlet.configuration = _configuration;
            }
        }
        return configuration;
    }

    public String getFreemarkerTemplatesPath() {
        this.throwException("Method 'getFreemarkerTemplatesPath' not implemented at class '?'", new Object[]{((Object)((Object)this)).getClass().getName()});
        return null;
    }

    public void processFreemarkerTemplate(AbstractHttpRequestContext requestContext, Object model) {
        this.processFreemarkerTemplate(requestContext, this.getPath(), model);
    }

    public void processFreemarkerTemplate(AbstractHttpRequestContext requestContext, String templateFileName, Object model) {
        FreemarkerProcessContext freemarkerContext = new FreemarkerProcessContext();
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("model", model);
        freemarkerContext.setDataModel(model);
        String languageDir = requestContext.getLanguage();
        String templatesPath = this.getFreemarkerTemplatesPath();
        freemarkerContext.setTemplateFileName(templatesPath + "/languages/" + languageDir + "/" + templateFileName + ".ftl");
        Template template = null;
        try {
            template = AbstractFreemarkerHttpServlet.getConfiguration().getTemplate(freemarkerContext.getTemplateFileName());
        }
        catch (Exception e) {
            try {
                freemarkerContext.setTemplateFileName(templatesPath + "/languages/common/" + templateFileName + ".ftl");
                template = AbstractFreemarkerHttpServlet.getConfiguration().getTemplate(freemarkerContext.getTemplateFileName());
            }
            catch (Exception e1) {
                e.printStackTrace();
                this.throwException("Template for current language get exception '?' and common get error '?'", new Object[]{new Object[]{e.getMessage(), e1.getMessage()}, e});
            }
        }
        try {
            StringWriter writer = new StringWriter();
            template.process(freemarkerContext.getDataModel(), (Writer)writer);
            this.write(requestContext, writer.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.throwException("Exception '?'", new Object[]{new Object[]{e.getMessage()}, e});
        }
    }
}

