/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.portal.common.servlet.http.protocol.javax;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.clawiz.core.common.CoreException;
import org.clawiz.core.common.utils.StringUtils;
import org.clawiz.portal.common.servlet.http.protocol.AbstractHttpRequestContext;
import org.clawiz.portal.common.servlet.http.protocol.HttpMethod;

public abstract class HttpServletRequestContext
extends AbstractHttpRequestContext {
    HttpServletRequest httpServletRequest;
    HttpMethod httpMethod;
    ArrayList<String> parameterNames;
    HashMap<String, String[]> parameterValues;

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public void setHttpServletRequest(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
    }

    @Override
    public void prepare() {
        super.prepare();
        this.httpMethod = HttpMethod.toMethod(this.httpServletRequest.getMethod());
    }

    @Override
    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    @Override
    public String getHeader(String header) {
        return this.httpServletRequest.getHeader(header);
    }

    @Override
    public Cookie getCookie(String name) {
        if (name == null) {
            return null;
        }
        for (Cookie cookie : this.httpServletRequest.getCookies()) {
            if (!name.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    @Override
    public String getCookieValue(String name) {
        Cookie cookie = this.getCookie(name);
        return cookie != null ? cookie.getValue() : null;
    }

    protected void prepareParameters() {
        this.parameterNames = new ArrayList();
        this.parameterValues = new HashMap();
        Enumeration names = this.httpServletRequest.getParameterNames();
        while (names.hasMoreElements()) {
            String sourceName = (String)names.nextElement();
            if (sourceName == null) continue;
            try {
                String[] values = this.httpServletRequest.getParameterValues(sourceName);
                String encodedSourceName = new String(sourceName.getBytes("ISO-8859-1"));
                this.parameterValues.put(encodedSourceName, values);
                this.parameterNames.add(encodedSourceName);
            }
            catch (UnsupportedEncodingException e) {
                throw new CoreException("Unsupported encoding exception on parameter name '?'", new Object[]{sourceName});
            }
        }
    }

    public ArrayList<String> getParameterNames() {
        if (this.parameterNames == null) {
            this.prepareParameters();
        }
        return this.parameterNames;
    }

    public HashMap<String, String[]> getParameterValues() {
        if (this.parameterValues == null) {
            this.prepareParameters();
        }
        return this.parameterValues;
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.getParameterValues().get(name != null ? name : null);
    }

    @Override
    public String getParameterValue(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null && values.length > 1) {
            throw new CoreException("Parameter '?' has more than one value", new Object[]{name});
        }
        return values != null ? values[0] : null;
    }

    @Override
    public String getParameterValue(String parameter, boolean throwErrorOnNotFound) {
        String value = this.getParameterValue(parameter);
        if (throwErrorOnNotFound && StringUtils.isEmpty((String)value)) {
            throw new CoreException("Parameter '?' must be defined", new Object[]{parameter});
        }
        return value;
    }
}

