/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.portal.common;

import org.clawiz.core.common.Core;
import org.clawiz.core.common.system.config.Config;
import org.clawiz.core.common.system.service.Service;
import org.clawiz.core.common.utils.RandomGUID;
import org.clawiz.core.common.utils.StringUtils;
import org.clawiz.portal.common.PortalContext;
import org.clawiz.portal.common.PortalSessionTimeoutDispatcher;
import org.clawiz.portal.common.engine.EngineContext;
import org.clawiz.portal.common.engine.PortalEngine;
import org.clawiz.portal.common.site.AbstractSiteContext;
import org.clawiz.portal.common.site.application.AbstractApplicationContext;

public class Portal
extends Service {
    public static final String CONFIG_PORTAL_ENGINE = "engine";
    public static final String CONFIG_PORTAL_SITE = "site";
    public static final String CONFIG_ENGINE_CLASS = "class";
    public static final String CONFIG_SITE_NAME = "name";
    public static final String CONFIG_SITE_PORT = "port";
    public static final String CONFIG_SITE_DEFAULT_PORT = "80";
    public static final String CONFIG_SITE_CONTEXT = "class";
    public static final String CONFIG_SITE_ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String CONFIG_SITE_APPLICATION_CONTEXT = "application";
    public static final String CONFIG_APPLICATION_CLASS = "class";
    Config config;
    private int portalsCount = 0;

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public AbstractSiteContext prepareSiteContext(Config config, PortalContext portalContext) {
        Config connectionConfig;
        String name = config.getString(CONFIG_SITE_NAME);
        String contextClassName = config.getString("class");
        if (StringUtils.isEmpty((String)contextClassName)) {
            this.throwException("Site '?' value of 'class' attribute not defined", new Object[]{name});
        }
        AbstractSiteContext siteContext = null;
        try {
            siteContext = (AbstractSiteContext)this.getService(Core.getClassByName((String)contextClassName), contextClassName + ":" + new RandomGUID().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.throwException("Site '?' context class '?' instantiation exception : ?'", new Object[]{new Object[]{name, contextClassName, e.getMessage()}, e});
        }
        siteContext.setPortalContext(portalContext);
        siteContext.setConfig(config);
        siteContext.setSiteName(name);
        String portString = config.getString(CONFIG_SITE_PORT);
        if (StringUtils.isEmpty((String)portString)) {
            portString = CONFIG_SITE_DEFAULT_PORT;
        }
        siteContext.setHttpPort(StringUtils.toBigDecimal((String)portString).intValue());
        siteContext.setAccessControlAllowOrigin(config.getString(CONFIG_SITE_ACCESS_CONTROL_ALLOW_ORIGIN));
        for (Config applicationConfig : config.getConfigList(CONFIG_SITE_APPLICATION_CONTEXT)) {
            String className = applicationConfig.getString("class", false);
            if (StringUtils.isEmpty((String)className)) {
                this.throwException("Application class not defined for site '?' application '?'", new Object[]{siteContext.getFullName(), applicationConfig.getString(CONFIG_SITE_NAME, "NULL")});
            }
            AbstractApplicationContext applicationContext = null;
            try {
                applicationContext = (AbstractApplicationContext)this.getService(Core.getClassByName((String)className), className + ":" + new RandomGUID().toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.throwException("Site '?' application class '?' instantiation exception : ?'", new Object[]{new Object[]{name, className, e.getMessage()}, e});
            }
            applicationContext.setConfig(applicationConfig);
            siteContext.addApplication(applicationContext);
        }
        Config dataSourceConfig = config.getConfig("datasource");
        if (dataSourceConfig != null && (connectionConfig = dataSourceConfig.getConfig("connection")) != null) {
            siteContext.getDataSourceContext().getConnectionContext().setCloseAfterCall(StringUtils.toBoolean((String)connectionConfig.getString("close-after-call", "true")));
            siteContext.getDataSourceContext().getConnectionContext().setCommitOnSuccess(StringUtils.toBoolean((String)connectionConfig.getString("commit-on-success", "true")));
            siteContext.getDataSourceContext().getConnectionContext().setRollbackOnFailure(StringUtils.toBoolean((String)connectionConfig.getString("rollback-on-failure", "true")));
        }
        siteContext.prepare();
        siteContext.prepareApplications();
        portalContext.addSite(siteContext);
        return siteContext;
    }

    public EngineContext prepareEngineContext(Config config, PortalContext portalContext) {
        EngineContext context = (EngineContext)this.getService(EngineContext.class, EngineContext.class.getName() + ":" + new RandomGUID().toString());
        context.setPortalContext(portalContext);
        String engineClassName = config.getString("class", true);
        context.setEngineClassName(engineClassName);
        PortalEngine engine = (PortalEngine)this.getService(Core.getClassByName((String)engineClassName), engineClassName + ":" + new RandomGUID().toString());
        engine.setPortalContext(portalContext);
        context.setEngine(engine);
        context.prepare();
        return context;
    }

    public PortalContext preparePortalContext(Config config) {
        PortalContext portalContext = (PortalContext)this.getService(PortalContext.class, PortalContext.class.getName() + ":" + this.portalsCount++);
        portalContext.setConfig(config);
        portalContext.setEngineContext(this.prepareEngineContext(config.getConfig(CONFIG_PORTAL_ENGINE), portalContext));
        for (Config siteConfig : config.getConfigList(CONFIG_PORTAL_SITE)) {
            AbstractSiteContext abstractSiteContext = this.prepareSiteContext(siteConfig, portalContext);
        }
        portalContext.prepare();
        return portalContext;
    }

    public void start() {
        PortalContext portalContext = this.preparePortalContext(this.getConfig());
        portalContext.getEngineContext().getEngine().start();
        PortalSessionTimeoutDispatcher timeoutDispatcher = (PortalSessionTimeoutDispatcher)Core.newDispatcherSession((String)PortalSessionTimeoutDispatcher.class.getName()).getService(PortalSessionTimeoutDispatcher.class, new RandomGUID().toString());
        timeoutDispatcher.setPortalContext(portalContext);
        timeoutDispatcher.start();
    }
}

