/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.portal.common;

import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.Cookie;
import org.clawiz.core.common.CoreException;
import org.clawiz.core.common.system.session.Session;
import org.clawiz.portal.common.servlet.AbstractServlet;
import org.clawiz.portal.common.servlet.ServletContext;
import org.clawiz.portal.common.site.AbstractSiteContext;

public class PortalSession {
    private Session coreSession;
    private Cookie sessionCookie;
    private AbstractSiteContext siteContext;
    private long lastActivityTime;
    private final ConcurrentHashMap<String, AbstractServlet> servletsCache = new ConcurrentHashMap();

    public PortalSession(Session coreSession) {
        this.coreSession = coreSession;
        this.lastActivityTime = new Date().getTime();
    }

    public long getLastActivityTime() {
        return this.lastActivityTime;
    }

    public String getKey() {
        return this.coreSession.getKey();
    }

    public Cookie getSessionCookie() {
        return this.sessionCookie;
    }

    public void setSessionCookie(Cookie sessionCookie) {
        this.sessionCookie = sessionCookie;
    }

    public AbstractSiteContext getSiteContext() {
        return this.siteContext;
    }

    public void setSiteContext(AbstractSiteContext siteContext) {
        this.siteContext = siteContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AbstractServlet> T lockServlet(ServletContext servletContext) {
        AbstractServlet servlet;
        this.lastActivityTime = new Date().getTime();
        if (servletContext.getServletClass() == null) {
            throw new CoreException("Servlet class nod defined in servlet context ? at path ?", new Object[]{((Object)((Object)servletContext)).toString(), servletContext.getPath()});
        }
        String servletKey = servletContext.getServletClass().getName() + "/" + servletContext.getPath();
        ConcurrentHashMap<String, AbstractServlet> concurrentHashMap = this.servletsCache;
        synchronized (concurrentHashMap) {
            servlet = this.servletsCache.get(servletKey);
            if (servlet == null) {
                servlet = (AbstractServlet)this.coreSession.getService(servletContext.getServletClass());
                this.servletsCache.put(servletKey, servlet);
            }
        }
        if (servlet.isAllowedSessionConcurrentCalls()) {
            return (T)((Object)servlet);
        }
        boolean lockObtained = false;
        while (!lockObtained) {
            AbstractServlet abstractServlet = servlet;
            synchronized (abstractServlet) {
                if (!servlet.isLocked()) {
                    servlet.getLock();
                    lockObtained = true;
                }
            }
            if (lockObtained) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return (T)((Object)servlet);
    }

    public void logout() {
        this.coreSession.logout();
        this.servletsCache.clear();
    }

    public boolean login(String userName, String password) {
        this.logout();
        return this.coreSession.login(userName, password);
    }

    public boolean isRegistered() {
        return this.coreSession.isRegistered();
    }

    public Session getCoreSession() {
        return this.coreSession;
    }
}

