/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.portal.common;

import java.util.Date;
import org.clawiz.core.common.system.server.dispatcher.AbstractDispatcher;
import org.clawiz.core.common.system.service.NotInitializeService;
import org.clawiz.portal.common.PortalContext;
import org.clawiz.portal.common.PortalPortContext;
import org.clawiz.portal.common.PortalSession;
import org.clawiz.portal.common.site.AbstractSiteContext;

public class PortalSessionTimeoutDispatcher
extends AbstractDispatcher {
    @NotInitializeService
    PortalContext portalContext;

    public void setPortalContext(PortalContext portalContext) {
        this.portalContext = portalContext;
    }

    protected void onTime() {
        long currentTime = new Date().getTime();
        for (PortalPortContext portContext : this.portalContext.getPorts()) {
            for (AbstractSiteContext site : portContext.getSites()) {
                for (PortalSession session : site.getSessions()) {
                    if (currentTime - session.getLastActivityTime() <= site.getSessionTimeout()) continue;
                    this.logDebug("Destroy timeout portal session " + session.getKey());
                    site.destroySession(session.getKey());
                }
            }
        }
    }
}

