/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.portal.common.engine.jetty;

import java.io.File;
import org.clawiz.portal.common.PortalPortContext;
import org.clawiz.portal.common.engine.PortalEngine;
import org.clawiz.portal.common.engine.jetty.handler.JettySiteNotFoundHandler;
import org.clawiz.portal.common.engine.jetty.handler.JettySiteServletHandler;
import org.clawiz.portal.common.servlet.FilesServletContext;
import org.clawiz.portal.common.site.AbstractSiteContext;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.resource.Resource;

public class JettyPortalEngine
extends PortalEngine {
    @Override
    public void start() {
        for (PortalPortContext portContext : this.getPortalContext().getPorts()) {
            Server server = new Server();
            HttpConfiguration httpConfig = new HttpConfiguration();
            ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
            connector.setPort(portContext.getPort());
            connector.setIdleTimeout(30000L);
            server.addConnector((Connector)connector);
            HandlerList serverHandlers = new HandlerList();
            server.setHandler((Handler)serverHandlers);
            ContextHandlerCollection serverContexts = new ContextHandlerCollection();
            serverHandlers.addHandler((Handler)serverContexts);
            for (AbstractSiteContext siteContext : portContext.getSites()) {
                for (FilesServletContext fc : siteContext.getFiles()) {
                    ResourceHandler rh;
                    ContextHandler contextHandler = new ContextHandler();
                    contextHandler.setContextPath(fc.getPath());
                    serverContexts.addHandler((Handler)contextHandler);
                    if (fc.isUseClassLoader()) {
                        rh = new ResourceHandler();
                        contextHandler.setHandler((Handler)rh);
                        rh.setBaseResource(Resource.newClassPathResource((String)fc.getLocalPath()));
                        rh.setDirectoriesListed(fc.isDirectoriesListed());
                        continue;
                    }
                    rh = new ResourceHandler();
                    contextHandler.setHandler((Handler)rh);
                    rh.setBaseResource(Resource.newResource((File)new File(fc.getLocalPath())));
                    rh.setDirectoriesListed(fc.isDirectoriesListed());
                }
                JettySiteServletHandler servletContextHandler = new JettySiteServletHandler();
                servletContextHandler.setSiteContext(siteContext);
                serverHandlers.addHandler((Handler)servletContextHandler);
            }
            if (portContext.getSites().size() > 0) {
                JettySiteNotFoundHandler notFoundHandler = new JettySiteNotFoundHandler();
                notFoundHandler.setSiteContext(portContext.getSites().get(0));
                serverHandlers.addHandler((Handler)notFoundHandler);
            }
            try {
                server.start();
            }
            catch (Exception e) {
                this.throwException("Exception on start jetty server ?", new Object[]{new Object[]{e.getMessage()}, e});
            }
        }
    }
}

