/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.portal.common.engine.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.clawiz.portal.common.PortalPortContext;
import org.clawiz.portal.common.engine.PortalEngine;
import org.clawiz.portal.common.engine.netty.http.NettyServerHttpInitializer;

public class NettyPortalEngine
extends PortalEngine {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        ServerBootstrap b = new ServerBootstrap();
        for (PortalPortContext portContext : this.getPortalContext().getPorts()) {
            NioEventLoopGroup bossGroup = new NioEventLoopGroup();
            NioEventLoopGroup workerGroup = new NioEventLoopGroup();
            try {
                NettyServerHttpInitializer portInitializer = new NettyServerHttpInitializer();
                portInitializer.setPortContext(portContext);
                ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)portInitializer);
                Channel ch = b.bind(portContext.getPort()).sync().channel();
                ch.closeFuture().sync();
            }
            catch (Exception e) {
                this.throwException("Exception on netty initialization ?", new Object[]{new Object[]{e.getMessage()}, e});
            }
            finally {
                bossGroup.shutdownGracefully();
                workerGroup.shutdownGracefully();
            }
        }
    }
}

