/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.portal.common.engine.netty.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.clawiz.core.common.Core;
import org.clawiz.core.common.CoreException;
import org.clawiz.core.common.system.logger.Logger;
import org.clawiz.portal.common.PortalPortContext;
import org.clawiz.portal.common.PortalSession;
import org.clawiz.portal.common.engine.netty.NettyHttpRequestContext;
import org.clawiz.portal.common.engine.netty.NettyHttpResponseContext;
import org.clawiz.portal.common.engine.netty.http.HttpStaticFileServerHandler;
import org.clawiz.portal.common.servlet.AbstractRequestFailContext;
import org.clawiz.portal.common.servlet.AbstractServlet;
import org.clawiz.portal.common.servlet.FilesServletContext;
import org.clawiz.portal.common.servlet.ServletContext;
import org.clawiz.portal.common.servlet.http.AbstractHttpServlet;
import org.clawiz.portal.common.servlet.http.protocol.AbstractHttpRequestContext;
import org.clawiz.portal.common.servlet.http.protocol.Header;
import org.clawiz.portal.common.servlet.http.protocol.HttpMethod;
import org.clawiz.portal.common.site.AbstractSiteContext;

public class NettyHttpServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String HTTP_DATE_GMT_TIMEZONE = "GMT";
    public static final int HTTP_CACHE_SECONDS = 60;
    PortalPortContext portContext;
    private NettyHttpRequestContext requestContext = new NettyHttpRequestContext();
    private NettyHttpResponseContext responseContext = new NettyHttpResponseContext();
    private HttpRequest request;
    HttpStaticFileServerHandler httpStaticFileServerHandler;
    Logger logger;

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public PortalPortContext getPortContext() {
        return this.portContext;
    }

    public void setPortContext(PortalPortContext portContext) {
        this.portContext = portContext;
    }

    private AbstractRequestFailContext getFail(String code, String message, Exception e) {
        AbstractRequestFailContext result = new AbstractRequestFailContext();
        result.setCode(code);
        result.setMessage(message);
        result.setExceiption(e);
        result.setRequest(this.requestContext);
        return result;
    }

    private HttpStaticFileServerHandler getHttpStaticFileServerHandler() throws Exception {
        if (this.httpStaticFileServerHandler == null) {
            this.httpStaticFileServerHandler = new HttpStaticFileServerHandler();
        }
        throw new Exception("Implmeneted file utils set");
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Core.getLogger(((Object)((Object)this)).getClass());
        }
        return this.logger;
    }

    private void logDebug(String msg) {
        this.getLogger().debug(msg);
    }

    protected void prepareRequestContext(HttpRequest request) {
        this.requestContext = new NettyHttpRequestContext();
        this.responseContext = new NettyHttpResponseContext();
        this.requestContext.setResponse(this.responseContext);
        this.responseContext.setRequest(this.requestContext);
        AbstractSiteContext siteContext = this.portContext.getSites().get(0);
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(request.getUri());
        String cookieString = request.headers().get("Cookie");
        if (cookieString != null) {
            for (io.netty.handler.codec.http.cookie.Cookie nettyCookie : ServerCookieDecoder.STRICT.decode(cookieString)) {
                Cookie cookie = new Cookie(nettyCookie.name(), nettyCookie.value());
                cookie.setDomain(nettyCookie.domain());
                cookie.setPath(nettyCookie.path());
                cookie.setMaxAge((int)nettyCookie.maxAge());
                cookie.setSecure(nettyCookie.isSecure());
                cookie.setHttpOnly(nettyCookie.isHttpOnly());
                this.requestContext.getResponse().setCookie(cookie);
            }
        }
        PortalSession portalSession = null;
        String sessionId = this.requestContext.getCookieValue(siteContext.getSessionIdParameterName());
        portalSession = siteContext.getSession(sessionId);
        if (portalSession == null) {
            portalSession = siteContext.newSession();
            this.responseContext.setCookie(portalSession.getSessionCookie());
        }
        this.requestContext.setPortalSession(portalSession);
        this.requestContext.setMethod(HttpMethod.toMethod(request.getMethod().toString()));
        if (this.requestContext.getMethod() == HttpMethod.POST) {
            HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)new DefaultHttpDataFactory(false), request);
            for (InterfaceHttpData data : decoder.getBodyHttpDatas()) {
                if (data.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
                Attribute attribute = (Attribute)data;
                try {
                    String value = attribute.getValue();
                    String[] values = new String[]{value};
                    this.requestContext.getParametersHashMap().put(attribute.getName(), values);
                }
                catch (IOException e) {
                    throw new CoreException("Core exception on get attribute '?' value : ?", new Object[]{new Object[]{attribute.getName(), e.getMessage()}, e});
                }
            }
        }
        this.requestContext.setUri(request.getUri());
        this.requestContext.setPath(queryStringDecoder.path());
        for (Map.Entry h : request.headers()) {
            String key = (String)h.getKey();
            String value = (String)h.getValue();
            this.requestContext.getHeaders().put(key, value);
        }
        for (String name : queryStringDecoder.parameters().keySet()) {
            List values = (List)queryStringDecoder.parameters().get(name);
            String[] sa = new String[values.size()];
            for (int i = 0; i < sa.length; ++i) {
                sa[i] = (String)values.get(i);
            }
            this.requestContext.getParametersHashMap().put(name, sa);
        }
        this.requestContext.prepare();
        this.responseContext.prepare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) {
        if (msg instanceof HttpRequest) {
            this.request = msg;
            AbstractRequestFailContext fail = null;
            try {
                this.prepareRequestContext(this.request);
                if (this.requestContext.getLocaleContext() == null) {
                    this.sendRedirect(ctx, "/" + this.requestContext.getSiteContext().getDefaultLocale().getLanguage() + this.request.getUri());
                    return;
                }
            }
            catch (CoreException e) {
                fail = this.getFail("500", e.getMessage(), (Exception)((Object)e));
            }
            if (fail == null) {
                Object servletContext = this.requestContext.getServletContext();
                if (servletContext == null) {
                    NettyHttpServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                    return;
                }
                if (servletContext instanceof FilesServletContext) {
                    FilesServletContext filesServletContext = (FilesServletContext)((Object)servletContext);
                    String path = this.requestContext.getPath();
                    if (this.requestContext.getLocaleContext() != null) {
                        path = path.substring(1 + this.requestContext.getLocaleContext().getLanguage().length());
                    }
                    String requestFileName = path.substring(servletContext.getPath().length());
                    String localFileName = filesServletContext.getLocalPath() + requestFileName;
                    try {
                        this.getHttpStaticFileServerHandler().setLocalFileName(localFileName);
                        this.getHttpStaticFileServerHandler().channelRead0(ctx, msg);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        fail = this.getFail("500", e.getMessage(), e);
                    }
                } else {
                    AbstractServlet abstractServlet = null;
                    try {
                        Object t = this.requestContext.getPortalSession().lockServlet((ServletContext)((Object)servletContext));
                        if (t instanceof AbstractHttpServlet) {
                            ((AbstractHttpServlet)((Object)t)).service(this.requestContext);
                        } else {
                            fail = this.getFail("500", "Servlet '" + servletContext.getPath() + " class '" + t.getClass().getName() + "' not inherited from AbstractHttpServlet", null);
                        }
                        if (t != null) {
                            ((AbstractServlet)((Object)t)).releaseLock();
                        }
                    }
                    catch (CoreException e) {
                        fail = this.getFail("500", e.getMessage(), (Exception)((Object)e));
                    }
                    finally {
                        if (abstractServlet != null) {
                            abstractServlet.releaseLock();
                        }
                    }
                }
            }
            if (fail != null) {
                String key;
                this.responseContext.write("Error " + fail.getCode() + " : " + fail.getMessage() + "\r\n\r\n<br><br>");
                this.responseContext.write("HOSTNAME      : " + this.requestContext.getHeader("Host") + "\r\n<br>");
                this.responseContext.write("REQUEST_URI   : " + this.requestContext.getUri() + "\r\n<br>");
                this.responseContext.write("PATH          : " + this.requestContext.getPath() + "\r\n<br>");
                if (this.requestContext.getHeaders().size() > 0) {
                    for (Map.Entry entry : this.requestContext.getHeaders().entrySet()) {
                        key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        this.responseContext.write("HEADER: " + key + " = " + value + "\r\n<br>");
                    }
                    this.responseContext.write("\r\n");
                }
                if (this.requestContext.getParametersHashMap().size() > 0) {
                    for (Map.Entry entry : this.requestContext.getParametersHashMap().entrySet()) {
                        String[] vals;
                        key = (String)entry.getKey();
                        for (String val : vals = (String[])entry.getValue()) {
                            this.responseContext.write("PARAM: " + key + " = " + val + "\r\n<br>");
                        }
                    }
                    this.responseContext.write("\r\n<br>");
                }
            }
            this.appendDecoderResult(this.requestContext);
        }
        if (!(msg instanceof HttpContent)) return;
        FullHttpRequest httpContent = msg;
        ByteBuf content = httpContent.content();
        if (content.isReadable()) {
            this.appendDecoderResult(this.requestContext);
        }
        if (!(msg instanceof LastHttpContent)) return;
        FullHttpRequest fullHttpRequest = msg;
        if (this.writeResponse((HttpObject)fullHttpRequest, ctx)) return;
        ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private void appendDecoderResult(AbstractHttpRequestContext requestContext) {
        DecoderResult result = this.request.getDecoderResult();
        if (result.isSuccess()) {
            return;
        }
        this.responseContext.write(".. WITH DECODER FAILURE: ");
        this.responseContext.write(result.cause().getMessage());
        this.responseContext.write("\r\n");
    }

    private void writeCookies(FullHttpResponse response) {
        for (Cookie cookie : this.responseContext.getCookies().values()) {
            DefaultCookie nettyCookie = new DefaultCookie(cookie.getName(), cookie.getValue());
            nettyCookie.setDomain(cookie.getDomain());
            nettyCookie.setPath(cookie.getPath());
            nettyCookie.setMaxAge((long)cookie.getMaxAge());
            nettyCookie.setHttpOnly(cookie.isHttpOnly());
            response.headers().add("Set-Cookie", (Object)ServerCookieEncoder.STRICT.encode((io.netty.handler.codec.http.cookie.Cookie)nettyCookie));
        }
    }

    private boolean writeResponse(HttpObject currentObj, ChannelHandlerContext ctx) {
        boolean keepAlive = HttpHeaders.isKeepAlive((HttpMessage)this.request);
        HttpResponseStatus status = HttpResponseStatus.valueOf((int)this.responseContext.getStatus().code());
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, currentObj.getDecoderResult().isSuccess() ? status : HttpResponseStatus.BAD_REQUEST, Unpooled.copiedBuffer((CharSequence)this.responseContext.getBuffer().toString(), (Charset)CharsetUtil.UTF_8));
        response.headers().set("Content-Type", (Object)((this.responseContext.getContentType() != null ? this.responseContext.getContentType() : "text/plain") + "; charset=" + (this.responseContext.getCharset() != null ? this.responseContext.getCharset() : "UTF-8")));
        if (keepAlive) {
            response.headers().set("Content-Length", (Object)response.content().readableBytes());
            response.headers().set("Connection", (Object)"keep-alive");
        }
        for (Header header : this.responseContext.getHeaders().values()) {
            response.headers().set(header.getName(), (Object)header.getValue());
        }
        this.writeCookies((FullHttpResponse)response);
        ctx.write((Object)response);
        return keepAlive;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }

    private static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + status + "\r\n"), (Charset)CharsetUtil.UTF_8));
        response.headers().set("Content-Type", (Object)"text/plain; charset=UTF-8");
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private void sendRedirect(ChannelHandlerContext ctx, String newUri) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FOUND);
        response.headers().set("Location", (Object)newUri);
        this.writeCookies((FullHttpResponse)response);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

