/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.portal.common.servlet.http.api.login;

import com.google.gson.JsonObject;
import java.math.BigDecimal;
import org.clawiz.core.common.storage.remotenode.RemoteNodeObject;
import org.clawiz.core.common.storage.remotenode.RemoteNodeService;
import org.clawiz.portal.common.servlet.http.AbstractHttpServlet;
import org.clawiz.portal.common.servlet.http.protocol.AbstractHttpRequestContext;

public class ApiLoginNodeServlet
extends AbstractHttpServlet {
    public static final String PARAMETER_NODENAME = "nodename";
    public static final String PARAMETER_PASSWORD = "password";
    RemoteNodeService remoteNodeService;

    @Override
    public String getPath() {
        return "/api/loginNode";
    }

    @Override
    public void doPost(AbstractHttpRequestContext context) {
        String status = "OK";
        String message = "";
        String nodeName = context.getParameterValue(PARAMETER_NODENAME, true);
        String password = context.getParameterValue(PARAMETER_PASSWORD, true);
        if (status.equals("OK")) {
            RemoteNodeObject nodeObject;
            BigDecimal nodeId = this.remoteNodeService.nameToId(nodeName);
            if (nodeId == null) {
                nodeObject = this.remoteNodeService.create();
                nodeObject.setName(nodeName);
                nodeObject.setPassword(password);
                nodeObject.save();
                nodeId = nodeObject.getId();
                this.commit();
                this.logDebug("New remote node registered : " + nodeName);
            }
            nodeObject = this.remoteNodeService.load(nodeId);
            if (!this.getSession().loginRemoteNode(nodeObject.getName(), password)) {
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.throwException("Wrong nodename or password", new Object[0]);
            }
        }
        JsonObject response = new JsonObject();
        response.addProperty("status", status);
        response.addProperty("message", message);
        if (this.getSession().getUserName() != null) {
            response.addProperty("username", this.getSession().getUserName());
        }
        this.write(context, response.toString());
    }
}

