/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.portal.common.servlet.http.api.response;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.clawiz.portal.common.servlet.http.api.response.ApiResponseJsonObject;

public class ApiResponseContext {
    public static final String STATUS_OK = "OK";
    public static final String STATUS_ERROR = "ERROR";
    String status = "OK";
    String message;
    String displayMessage;
    private static JsonSerializer<Date> isoUtcDateTypeAdapter = new JsonSerializer<Date>(){

        public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
            return src == null ? null : new JsonPrimitive(LocalDateTime.ofInstant(Instant.ofEpochMilli(src.getTime()), ZoneId.of("UTC")).format(DateTimeFormatter.ISO_DATE_TIME));
        }
    };

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public void setDisplayMessage(String displayMessage) {
        this.displayMessage = displayMessage;
    }

    public ApiResponseJsonObject createJsonObject() {
        return new ApiResponseJsonObject().withProperty("status", this.status).withProperty("message", this.message);
    }

    protected JsonSerializer<Date> getDateGsonTypeAdapter() {
        return isoUtcDateTypeAdapter;
    }

    public String toJson() {
        Gson gson = new GsonBuilder().registerTypeAdapter(Date.class, this.getDateGsonTypeAdapter()).create();
        return gson.toJson((Object)this);
    }
}

