/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.portal.common.servlet.http.html.login;

import javax.servlet.http.Cookie;
import org.clawiz.core.common.utils.StringUtils;
import org.clawiz.portal.common.servlet.ServletSecureMode;
import org.clawiz.portal.common.servlet.http.html.freemarker.AbstractFreemarkerHttpServlet;
import org.clawiz.portal.common.servlet.http.html.login.LoginServletDataModel;
import org.clawiz.portal.common.servlet.http.protocol.AbstractHttpRequestContext;

public class LoginServlet
extends AbstractFreemarkerHttpServlet {
    public static final String PARAMETER_USERNAME = "username";
    public static final String PARAMETER_PASSWORD = "password";

    @Override
    public boolean isAllowedSessionConcurrentCalls() {
        return false;
    }

    @Override
    public String getPath() {
        return "/login";
    }

    public String getLoginTemplateFileName(AbstractHttpRequestContext context) {
        return "login";
    }

    public String getLoginSuccessPath() {
        return "/";
    }

    @Override
    public ServletSecureMode getSecureMode() {
        return ServletSecureMode.ALLOW_ALL;
    }

    protected void writeLoginPage(AbstractHttpRequestContext context, LoginServletDataModel dataModel) {
        this.processFreemarkerTemplate(context, this.getLoginTemplateFileName(context), dataModel);
    }

    @Override
    public void doGet(AbstractHttpRequestContext context) {
        LoginServletDataModel dataModel = this.getTemplateDataModel(context, LoginServletDataModel.class);
        this.writeLoginPage(context, dataModel);
    }

    protected String getLoginFailedMessage(AbstractHttpRequestContext context) {
        return "Unknown username or password is wrong";
    }

    public LoginServletDataModel login(AbstractHttpRequestContext context) {
        String userName = context.getParameterValue(PARAMETER_USERNAME);
        String password = context.getParameterValue(PARAMETER_PASSWORD);
        LoginServletDataModel dataModel = this.getTemplateDataModel(context, LoginServletDataModel.class);
        if (!context.getPortalSession().login(userName, password)) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            dataModel.setLoginFailed(true);
            dataModel.setLoginErrorMessage(this.getLoginFailedMessage(context));
            dataModel.setUsername(userName);
        }
        return dataModel;
    }

    public void afterLogin(AbstractHttpRequestContext context) {
        this.sendApplicationRedirect(context, this.getLoginSuccessPath());
    }

    public void redirectSuccessLogin(AbstractHttpRequestContext context) {
        Cookie redirectCookie = context.getCookie("CLAWIZ_REDIRECT_AFTER_LOGIN");
        if (redirectCookie != null && !StringUtils.isEmpty((String)redirectCookie.getValue())) {
            Cookie setCookie = new Cookie("CLAWIZ_REDIRECT_AFTER_LOGIN", "");
            setCookie.setMaxAge(0);
            context.getResponse().setCookie(setCookie);
            this.sendApplicationRedirect(context, redirectCookie.getValue());
        } else {
            this.afterLogin(context);
        }
    }

    @Override
    public void doPost(AbstractHttpRequestContext context) {
        LoginServletDataModel dataModel = this.login(context);
        if (dataModel.isLoginFailed()) {
            this.writeLoginPage(context, dataModel);
            return;
        }
        this.redirectSuccessLogin(context);
    }
}

