/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.portal.common.site;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.Cookie;
import org.clawiz.core.common.Core;
import org.clawiz.core.common.CoreException;
import org.clawiz.core.common.system.service.NotInitializeService;
import org.clawiz.core.common.system.session.Session;
import org.clawiz.core.common.utils.RandomGUID;
import org.clawiz.core.common.utils.StringUtils;
import org.clawiz.portal.common.AbstractContext;
import org.clawiz.portal.common.PortalContext;
import org.clawiz.portal.common.PortalSession;
import org.clawiz.portal.common.servlet.AbstractServlet;
import org.clawiz.portal.common.servlet.FilesServletContext;
import org.clawiz.portal.common.servlet.ServletContext;
import org.clawiz.portal.common.servlet.http.protocol.AbstractHttpRequestContext;
import org.clawiz.portal.common.site.LocaleContext;
import org.clawiz.portal.common.site.application.AbstractApplicationContext;
import org.clawiz.portal.common.site.application.ApplicationContextList;

public class AbstractSiteContext
extends AbstractContext {
    @NotInitializeService
    PortalContext portalContext;
    ApplicationContextList applicationContexts = new ApplicationContextList();
    ArrayList<ServletContext> servlets = new ArrayList();
    ArrayList<FilesServletContext> files = new ArrayList();
    HashMap<String, ServletContext> pathsCache = new HashMap();
    ArrayList<LocaleContext> locales = new ArrayList();
    HashMap<String, LocaleContext> localesCache = new HashMap();
    LocaleContext defaultLocale = null;
    String siteName;
    int httpPort;
    String accessControlAllowOrigin;
    String loginPath = "/login";
    String defaultSecuredPath = "/";
    String defaultNotSecuredPath = "/";
    long sessionTimeout = 3600000L;
    String siteAutoLoginUserName;
    String siteAutoLoginUserPassword;
    DataSourceContext dataSourceContext = new DataSourceContext();
    private ConcurrentHashMap<String, PortalSession> sessionsCache = new ConcurrentHashMap();
    String sessionIdParameterName = "cwsessionid";

    public String getSessionIdParameterName() {
        return this.sessionIdParameterName;
    }

    public PortalSession getSession(String id) {
        return StringUtils.isEmpty((String)id) ? null : this.sessionsCache.get(id);
    }

    public PortalSession newSession() {
        Session coreSession = Core.newSession();
        PortalSession portalSession = new PortalSession(coreSession);
        portalSession.setSiteContext(this);
        this.sessionsCache.put(portalSession.getKey(), portalSession);
        this.logDebug("Portal session created " + portalSession.getKey());
        Cookie cookie = new Cookie(this.getSessionIdParameterName(), portalSession.getKey());
        cookie.setPath("/");
        cookie.setHttpOnly(true);
        portalSession.setSessionCookie(cookie);
        return portalSession;
    }

    public Collection<PortalSession> getSessions() {
        return this.sessionsCache.values();
    }

    public void destroySession(String id) {
        PortalSession session = this.getSession(id);
        if (session == null) {
            throw new CoreException("Session '?' does not exists", new Object[]{id});
        }
        Core.getSessions().destroySession(session.getCoreSession());
        this.sessionsCache.remove(id);
    }

    public void putSession(String id, PortalSession session) {
        this.sessionsCache.put(id, session);
    }

    public PortalContext getPortalContext() {
        return this.portalContext;
    }

    public void setPortalContext(PortalContext portalContext) {
        this.portalContext = portalContext;
    }

    public DataSourceContext getDataSourceContext() {
        return this.dataSourceContext;
    }

    public void makeAddPath(ServletContext context) {
        if (this.pathsCache.containsKey(context.getPath())) {
            ServletContext sc = this.pathsCache.get(context.getPath());
            throw new CoreException("Path '?' already defined for servlet '?' of site '?'", new Object[]{context.getPath(), sc.getServletClass().getName(), this.getFullName()});
        }
        this.pathsCache.put(context.getPath(), context);
    }

    public LocaleContext getLocaleByPath(String path) {
        if (path == null) {
            return null;
        }
        if (path.charAt(0) != '/') {
            return null;
        }
        int i = path.indexOf("/", 2);
        if (i < 0) {
            return null;
        }
        return this.localesCache.get(path.substring(1, i).toUpperCase());
    }

    public LocaleContext getLocaleByRequest(AbstractHttpRequestContext request) {
        return this.getLocaleByPath(request.getPath());
    }

    public String removeLocaleFromPath(String path, LocaleContext localeContext) {
        if (localeContext == null) {
            return path;
        }
        String languagePrefix = "/" + localeContext.getLanguage();
        if (path.length() >= languagePrefix.length() && path.substring(0, languagePrefix.length()).equalsIgnoreCase(languagePrefix)) {
            return path.substring(languagePrefix.length());
        }
        return path;
    }

    public ServletContext getServletContextByPath(String path, LocaleContext localeContext) {
        if (path == null) {
            return null;
        }
        ServletContext context = this.pathsCache.get(path = this.removeLocaleFromPath(path, localeContext));
        if (context != null) {
            return context;
        }
        for (FilesServletContext fileContext : this.files) {
            if (path.length() < fileContext.getPath().length() || !path.substring(0, fileContext.getPath().length()).equalsIgnoreCase(fileContext.getPath())) continue;
            return fileContext;
        }
        return null;
    }

    public ServletContext getServletContextByRequest(AbstractHttpRequestContext request) {
        return this.getServletContextByPath(request.getPath(), request.getLocaleContext());
    }

    private void addServlet(ServletContext context) {
        this.servlets.add(context);
        this.makeAddPath(context);
    }

    public <T extends AbstractServlet> ServletContext addServlet(Class<T> clazz, String path, AbstractApplicationContext applicationContext) {
        ServletContext context = (ServletContext)this.getService(ServletContext.class, ServletContext.class.getName() + ":" + new RandomGUID().toString());
        context.setServletClass(clazz, this.getSession());
        context.setPath(path);
        context.setApplicationContext(applicationContext);
        this.addServlet(context);
        return context;
    }

    public ArrayList<ServletContext> getServlets() {
        return this.servlets;
    }

    public FilesServletContext addFiles(String localPath, String path) {
        FilesServletContext context = (FilesServletContext)this.getService(FilesServletContext.class, FilesServletContext.class.getName() + ":" + new RandomGUID().toString());
        context.setPath(path);
        context.setLocalPath(localPath);
        this.addFiles(context);
        return context;
    }

    public void addFiles(FilesServletContext context) {
        this.files.add(context);
        this.makeAddPath(context);
    }

    public ArrayList<FilesServletContext> getFiles() {
        return this.files;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String name) {
        this.siteName = name;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int port) {
        this.httpPort = port;
    }

    public String getAccessControlAllowOrigin() {
        return this.accessControlAllowOrigin;
    }

    public void setAccessControlAllowOrigin(String accessControlAllowOrigin) {
        this.accessControlAllowOrigin = accessControlAllowOrigin;
    }

    public String getFullName() {
        return (this.portalContext != null ? this.portalContext.getName() + "." : "") + this.getSiteName();
    }

    public ArrayList<LocaleContext> getLocales() {
        return this.locales;
    }

    public LocaleContext getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(LocaleContext defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public void addLocale(LocaleContext locale) {
        String key = locale.getLanguage();
        if (StringUtils.isEmpty((String)key)) {
            throw new CoreException("Locale language must be defined", new Object[0]);
        }
        if (this.localesCache.get(key = key.toUpperCase()) != null) {
            return;
        }
        this.localesCache.put(key, locale);
        this.locales.add(locale);
    }

    public LocaleContext addLanguage(String language) {
        LocaleContext locale = new LocaleContext();
        locale.setLanguage(language);
        this.addLocale(locale);
        return locale;
    }

    public String getLoginPath() {
        return this.loginPath;
    }

    public void setLoginPath(String loginPath) {
        this.loginPath = loginPath;
    }

    public String getDefaultSecuredPath() {
        return this.defaultSecuredPath;
    }

    public void setDefaultSecuredPath(String defaultSecuredPath) {
        this.defaultSecuredPath = defaultSecuredPath;
    }

    @Override
    public void prepare() {
        super.prepare();
        if (this.locales.size() == 0) {
            LocaleContext locale = this.addLanguage("en");
            this.setDefaultLocale(locale);
        }
    }

    public void prepareApplications() {
        for (AbstractApplicationContext applicationContext : this.applicationContexts) {
            applicationContext.prepare();
        }
    }

    public String getDefaultNotSecuredPath() {
        return this.defaultNotSecuredPath;
    }

    public void setDefaultNotSecuredPath(String defaultNotSecuredPath) {
        this.defaultNotSecuredPath = defaultNotSecuredPath;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void addApplication(AbstractApplicationContext applicationContext) {
        applicationContext.setSiteContext(this);
        this.applicationContexts.add(applicationContext);
    }

    public ApplicationContextList getApplicationContexts() {
        return this.applicationContexts;
    }

    public String getSiteAutoLoginUserName() {
        return this.siteAutoLoginUserName;
    }

    public void setSiteAutoLoginUserName(String siteUserName) {
        this.siteAutoLoginUserName = siteUserName;
    }

    public String getSiteAutoLoginUserPassword() {
        return this.siteAutoLoginUserPassword;
    }

    public void setSiteAutoLoginUserPassword(String siteAutoLoginUserPassword) {
        this.siteAutoLoginUserPassword = siteAutoLoginUserPassword;
    }

    public class DataSourceContext {
        DataSourceConnectionContext connectionContext;

        public DataSourceContext() {
            this.connectionContext = new DataSourceConnectionContext();
        }

        public DataSourceConnectionContext getConnectionContext() {
            return this.connectionContext;
        }
    }

    public class DataSourceConnectionContext {
        boolean closeAfterCall = true;
        boolean commitOnSuccess = true;
        boolean rollbackOnFailure = true;

        public boolean isCloseAfterCall() {
            return this.closeAfterCall;
        }

        public void setCloseAfterCall(boolean closeAfterCall) {
            this.closeAfterCall = closeAfterCall;
        }

        public boolean isCommitOnSuccess() {
            return this.commitOnSuccess;
        }

        public void setCommitOnSuccess(boolean commitOnSuccess) {
            this.commitOnSuccess = commitOnSuccess;
        }

        public boolean isRollbackOnFailure() {
            return this.rollbackOnFailure;
        }

        public void setRollbackOnFailure(boolean rollbackOnFailure) {
            this.rollbackOnFailure = rollbackOnFailure;
        }
    }
}

