/*
 * Decompiled with CFR 0.152.
 */
package org.clawiz.portal.common.site.application;

import org.clawiz.core.common.system.config.Config;
import org.clawiz.core.common.system.service.NotInitializeService;
import org.clawiz.core.common.utils.RandomGUID;
import org.clawiz.core.common.utils.StringUtils;
import org.clawiz.portal.common.AbstractContext;
import org.clawiz.portal.common.servlet.AbstractServlet;
import org.clawiz.portal.common.servlet.FilesServletContext;
import org.clawiz.portal.common.servlet.ServletContext;
import org.clawiz.portal.common.servlet.http.error.AbstractHttpErrorHandlerServlet;
import org.clawiz.portal.common.servlet.http.error.DefaultHttpErrorHandlerServlet;
import org.clawiz.portal.common.site.AbstractSiteContext;

public class AbstractApplicationContext
extends AbstractContext {
    public static final String CONFIG_NAME = "name";
    public static final String CONFIG_PATH = "path";
    @NotInitializeService
    AbstractSiteContext siteContext;
    String path;
    String name;
    @NotInitializeService
    private ServletContext httpErrorHandler;
    private static int appIndex = 0;

    public AbstractSiteContext getSiteContext() {
        return this.siteContext;
    }

    public void setSiteContext(AbstractSiteContext siteContext) {
        this.siteContext = siteContext;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public void setConfig(Config config) {
        super.setConfig(config);
        String name = config.getString(CONFIG_NAME, false);
        if (name == null) {
            name = "APP" + appIndex++;
        }
        this.setName(name);
        String path = config.getString(CONFIG_PATH, "");
        this.setPath(path);
    }

    public String addApplicationPath(String path) {
        String result;
        boolean rootPath;
        boolean bl = rootPath = StringUtils.isEmpty((String)path) || path.equals("/");
        if (rootPath) {
            if (StringUtils.isEmpty((String)this.path) || this.path.equals("/")) {
                return "/";
            }
            result = this.path;
        } else {
            result = this.path + "/" + path;
        }
        String replaced = result.replaceAll("//", "/");
        while (!replaced.equals(result)) {
            result = replaced;
            replaced = result.replaceAll("//", "/");
        }
        return result;
    }

    public FilesServletContext addFiles(String localPath, String path) {
        return this.getSiteContext().addFiles(localPath, this.addApplicationPath(path));
    }

    public <T extends AbstractServlet> ServletContext addServlet(Class<T> clazz, String path) {
        ServletContext servlet = this.getSiteContext().addServlet(clazz, this.addApplicationPath(path), this);
        return servlet;
    }

    public <T extends AbstractServlet> ServletContext addServlet(Class<T> clazz) {
        return this.addServlet(clazz, ((AbstractServlet)this.getService(clazz)).getPath());
    }

    public ServletContext getHttpErrorHandler() {
        return this.httpErrorHandler;
    }

    public void setHttpErrorHandler(ServletContext httpErrorHandler) {
        this.httpErrorHandler = httpErrorHandler;
    }

    public <T extends AbstractHttpErrorHandlerServlet> void setHttpErrorHandler(Class<T> clazz) {
        ServletContext context = (ServletContext)this.getService(ServletContext.class, ServletContext.class.getName() + ":" + new RandomGUID().toString());
        context.setServletClass(clazz, this.getSession());
        context.setApplicationContext(this);
        this.setHttpErrorHandler(context);
    }

    @Override
    public void prepare() {
        super.prepare();
        if (this.httpErrorHandler == null) {
            this.setHttpErrorHandler(DefaultHttpErrorHandlerServlet.class);
        }
    }
}

