/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.clearnlp;

import com.googlecode.clearnlp.component.AbstractComponent;
import com.googlecode.clearnlp.dependency.DEPFeat;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.engine.EngineGetter;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.clearnlp.PosTagger;
import org.cleartk.syntax.dependency.type.DependencyNode;
import org.cleartk.syntax.dependency.type.DependencyRelation;
import org.cleartk.syntax.dependency.type.TopDependencyNode;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;
import org.cleartk.util.UIMAUtil;
import org.uimafit.component.JCasAnnotator_ImplBase;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.descriptor.TypeCapability;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.util.JCasUtil;

@TypeCapability(inputs={"org.cleartk.token.type.Sentence", "org.cleartk.token.type.Token:pos", "org.cleartk.token.type.Token:lemma"}, outputs={"org.cleartk.syntax.dependency.type.TopDependencyNode", "org.cleartk.syntax.dependency.type.DependencyNode", "org.cleartk.syntax.dependency.type.DependencyNode"})
public class DependencyParser
extends JCasAnnotator_ImplBase {
    public static final String DEFAULT_MODEL_FILE_NAME = "ontonotes-en-dep-1.3.0.tgz";
    public static final String PARAM_PARSER_MODEL_URI = ConfigurationParameterFactory.createConfigurationParameterName(DependencyParser.class, (String)"parserModelUri");
    @ConfigurationParameter(description="This parameter provides the file name of the dependency parser model required by the factory method provided by ClearParserUtil.")
    private URI parserModelUri;
    public static final String PARAM_LANGUAGE_CODE = ConfigurationParameterFactory.createConfigurationParameterName(PosTagger.class, (String)"languageCode");
    @ConfigurationParameter(description="Language code for the pos tagger (default value=en).", defaultValue={"en"})
    private String languageCode;
    private AbstractComponent parser;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        try {
            URL parserModelURL = this.parserModelUri == null ? DependencyParser.class.getResource(DEFAULT_MODEL_FILE_NAME).toURI().toURL() : this.parserModelUri.toURL();
            this.parser = EngineGetter.getComponent((InputStream)parserModelURL.openStream(), (String)this.languageCode, (String)"dep");
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(DependencyParser.class, (Object[])new Object[0]);
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            List tokens = JCasUtil.selectCovered((JCas)jCas, Token.class, (AnnotationFS)sentence);
            DEPTree tree = new DEPTree();
            for (int i = 0; i < tokens.size(); ++i) {
                Token token = (Token)tokens.get(i);
                DEPNode node = new DEPNode(i + 1, token.getCoveredText(), token.getLemma(), token.getPos(), new DEPFeat());
                tree.add((Object)node);
            }
            this.parser.process(tree);
            this.addTreeToCas(jCas, tree, sentence, tokens);
        }
    }

    private void addTreeToCas(JCas jCas, DEPTree tree, Sentence sentence, List<Token> tokens) {
        DependencyNode[] nodes = new DependencyNode[tree.size()];
        TopDependencyNode rootNode = new TopDependencyNode(jCas, sentence.getBegin(), sentence.getEnd());
        rootNode.addToIndexes();
        nodes[0] = rootNode;
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            nodes[i + 1] = new DependencyNode(jCas, token.getBegin(), token.getEnd());
        }
        HashMap headRelations = new HashMap();
        HashMap childRelations = new HashMap();
        for (int i = 0; i < tree.size(); ++i) {
            DEPNode parserNode = tree.get(i);
            if (!parserNode.hasHead()) continue;
            int headIndex = parserNode.getHead().id;
            DependencyNode node = nodes[i];
            DependencyNode headNode = nodes[headIndex];
            DependencyRelation rel = new DependencyRelation(jCas);
            rel.setChild(node);
            rel.setHead(headNode);
            rel.setRelation(parserNode.getLabel());
            if (!headRelations.containsKey(node)) {
                headRelations.put(node, new ArrayList());
            }
            ((List)headRelations.get(node)).add(rel);
            if (!childRelations.containsKey(headNode)) {
                childRelations.put(headNode, new ArrayList());
            }
            ((List)childRelations.get(headNode)).add(rel);
        }
        for (DependencyNode node : nodes) {
            node.setHeadRelations(UIMAUtil.toFSArray((JCas)jCas, (List)((List)headRelations.get(node))));
            node.setChildRelations(UIMAUtil.toFSArray((JCas)jCas, (List)((List)childRelations.get(node))));
            node.addToIndexes();
        }
    }
}

