/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.clearnlp;

import com.googlecode.clearnlp.component.AbstractComponent;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.engine.EngineGetter;
import com.googlecode.clearnlp.nlp.NLPDecode;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;
import org.uimafit.component.JCasAnnotator_ImplBase;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.descriptor.TypeCapability;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.util.JCasUtil;

@TypeCapability(inputs={"org.cleartk.token.type.Token:pos"}, outputs={"org.cleartk.token.type.Token:lemma"})
public class MPAnalyzer
extends JCasAnnotator_ImplBase {
    public static final String DEFAULT_DICTIONARY_FILE_NAME = "dictionary-1.2.0.zip";
    public static final String PARAM_LANGUAGE_CODE = ConfigurationParameterFactory.createConfigurationParameterName(MPAnalyzer.class, (String)"languageCode");
    @ConfigurationParameter(description="Language code (default value=en).", defaultValue={"en"})
    private String languageCode;
    public static final String PARAM_DICTIONARY_URI = ConfigurationParameterFactory.createConfigurationParameterName(MPAnalyzer.class, (String)"dictionaryUri");
    @ConfigurationParameter(description="This parameter provides the URI to the morphological analyzer dictionary used for lemmatizing.")
    private URI dictionaryUri;
    private AbstractComponent mpAnalyzer;
    private NLPDecode clearNlpDecoder;

    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(MPAnalyzer.class, (Object[])new Object[0]);
    }

    public static AnalysisEngineDescription getDescription(String langCode, URI dictionaryUri) throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(MPAnalyzer.class, (Object[])new Object[]{PARAM_LANGUAGE_CODE, langCode, PARAM_DICTIONARY_URI, dictionaryUri});
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            URL mpAnalyzerDictionaryURL = this.dictionaryUri == null ? MPAnalyzer.class.getResource(DEFAULT_DICTIONARY_FILE_NAME).toURI().toURL() : this.dictionaryUri.toURL();
            this.mpAnalyzer = EngineGetter.getComponent((InputStream)mpAnalyzerDictionaryURL.openStream(), (String)this.languageCode, (String)"morph");
            this.clearNlpDecoder = new NLPDecode();
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            DEPNode node;
            Token token;
            int i;
            List tokens = JCasUtil.selectCovered((JCas)jCas, Token.class, (AnnotationFS)sentence);
            List tokenStrings = JCasUtil.toText((Iterable)tokens);
            DEPTree depTree = this.clearNlpDecoder.toDEPTree(tokenStrings);
            for (i = 1; i < depTree.size(); ++i) {
                token = (Token)tokens.get(i - 1);
                node = depTree.get(i);
                node.pos = token.getPos();
            }
            this.mpAnalyzer.process(depTree);
            for (i = 1; i < depTree.size(); ++i) {
                token = (Token)tokens.get(i - 1);
                node = depTree.get(i);
                token.setLemma(node.lemma);
            }
        }
    }
}

