/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.clearnlp;

import com.googlecode.clearnlp.component.AbstractComponent;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.engine.EngineGetter;
import com.googlecode.clearnlp.nlp.NLPDecode;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;
import org.uimafit.component.JCasAnnotator_ImplBase;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.descriptor.TypeCapability;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.util.JCasUtil;

@TypeCapability(inputs={"org.cleartk.token.type.Token"}, outputs={"org.cleartk.token.type.Token:pos"})
public class PosTagger
extends JCasAnnotator_ImplBase {
    public static final String DEFAULT_MODEL_FILE_NAME = "ontonotes-en-pos-1.3.0.tgz";
    public static final String PARAM_MODEL_URI = ConfigurationParameterFactory.createConfigurationParameterName(PosTagger.class, (String)"modelUri");
    @ConfigurationParameter(description="This parameter provides the URI to the pos tagger model.")
    private URI modelUri;
    public static final String PARAM_LANGUAGE_CODE = ConfigurationParameterFactory.createConfigurationParameterName(PosTagger.class, (String)"languageCode");
    @ConfigurationParameter(description="Language code for the pos tagger (default value=en).", defaultValue={"en"})
    private String languageCode;
    private AbstractComponent tagger;
    private NLPDecode clearNlpDecoder;

    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(PosTagger.class, (Object[])new Object[0]);
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            URL modelURL = this.modelUri == null ? PosTagger.class.getResource(DEFAULT_MODEL_FILE_NAME).toURI().toURL() : this.modelUri.toURL();
            this.tagger = EngineGetter.getComponent((InputStream)modelURL.openStream(), (String)this.languageCode, (String)"pos");
            this.clearNlpDecoder = new NLPDecode();
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            List tokens = JCasUtil.selectCovered((JCas)jCas, Token.class, (AnnotationFS)sentence);
            if (tokens.size() <= 0) {
                return;
            }
            List tokenStrings = JCasUtil.toText((Iterable)tokens);
            DEPTree clearNlpDepTree = this.clearNlpDecoder.toDEPTree(tokenStrings);
            this.tagger.process(clearNlpDepTree);
            String[] posTags = clearNlpDepTree.getPOSTags();
            for (int i = 0; i < tokens.size(); ++i) {
                Token token = (Token)tokens.get(i);
                token.setPos(posTags[i + 1]);
            }
        }
    }
}

