/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.clearnlp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.googlecode.clearnlp.component.AbstractComponent;
import com.googlecode.clearnlp.dependency.DEPArc;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.engine.EngineGetter;
import com.googlecode.clearnlp.nlp.NLPDecode;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.clearnlp.Tokenizer;
import org.cleartk.srl.type.Predicate;
import org.cleartk.srl.type.SemanticArgument;
import org.cleartk.syntax.dependency.type.DependencyNode;
import org.cleartk.syntax.dependency.type.DependencyRelation;
import org.cleartk.syntax.dependency.type.TopDependencyNode;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;
import org.cleartk.util.UIMAUtil;
import org.uimafit.component.JCasAnnotator_ImplBase;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.descriptor.TypeCapability;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.util.JCasUtil;

@TypeCapability(inputs={"org.cleartk.token.type.Sentence", "org.cleartk.token.type.Token:pos", "org.cleartk.token.type.Token:lemma", "org.cleartk.syntax.dependency.type.TopDependencyNode", "org.cleartk.syntax.dependency.type.DependencyNode", "org.cleartk.syntax.dependency.type.DependencyNode"}, outputs={"org.cleartk.srl.type.Predicate", "org.cleartk.srl.type.SemanticArgument"})
public class SemanticRoleLabeler
extends JCasAnnotator_ImplBase {
    public static final String DEFAULT_PRED_ID_MODEL_FILE_NAME = "ontonotes-en-pred-1.3.0.tgz";
    public static final String DEFAULT_ROLESET_MODEL_FILE_NAME = "ontonotes-en-role-1.3.0.tgz";
    public static final String DEFAULT_SRL_MODEL_FILE_NAME = "ontonotes-en-srl-1.3.0.tgz";
    public static final String PARAM_SRL_MODEL_URI = ConfigurationParameterFactory.createConfigurationParameterName(SemanticRoleLabeler.class, (String)"srlModelUri");
    @ConfigurationParameter(description="This parameter provides the URI pointing to the semantic role labeler model.  If none is specified it will use the default ontonotes model.")
    private URI srlModelUri;
    public static final String PARAM_PRED_ID_MODEL_URI = ConfigurationParameterFactory.createConfigurationParameterName(SemanticRoleLabeler.class, (String)"predIdModelUri");
    @ConfigurationParameter(description="This parameter provides the URI pointing to the predicate identifier model.  If none is specified it will use the default ontonotes model.")
    private URI predIdModelUri;
    public static final String PARAM_ROLESET_MODEL_URI = ConfigurationParameterFactory.createConfigurationParameterName(SemanticRoleLabeler.class, (String)"rolesetModelUri");
    @ConfigurationParameter(description="This parameter provides the URI pointing to the role set classifier model.  If none is specified it will use the default ontonotes model.")
    private URI rolesetModelUri;
    public static final String PARAM_LANGUAGE_CODE = ConfigurationParameterFactory.createConfigurationParameterName(Tokenizer.class, (String)"languageCode");
    @ConfigurationParameter(description="Language code for the semantic role labeler (default value=en).", defaultValue={"en"})
    private String languageCode;
    private AbstractComponent predIdentifier;
    private AbstractComponent roleSetClassifier;
    private AbstractComponent srlabeler;
    private NLPDecode clearNlpDecoder;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        try {
            URL predIdModelURL = this.predIdModelUri == null ? SemanticRoleLabeler.class.getResource(DEFAULT_PRED_ID_MODEL_FILE_NAME).toURI().toURL() : this.predIdModelUri.toURL();
            this.predIdentifier = EngineGetter.getComponent((InputStream)predIdModelURL.openStream(), (String)this.languageCode, (String)"pred");
            URL rolesetModelUrl = this.rolesetModelUri == null ? SemanticRoleLabeler.class.getResource(DEFAULT_ROLESET_MODEL_FILE_NAME).toURI().toURL() : this.rolesetModelUri.toURL();
            this.roleSetClassifier = EngineGetter.getComponent((InputStream)rolesetModelUrl.openStream(), (String)this.languageCode, (String)"role");
            URL srlModelURL = this.srlModelUri == null ? SemanticRoleLabeler.class.getResource(DEFAULT_SRL_MODEL_FILE_NAME).toURI().toURL() : this.srlModelUri.toURL();
            this.srlabeler = EngineGetter.getComponent((InputStream)srlModelURL.openStream(), (String)this.languageCode, (String)"srl");
            this.clearNlpDecoder = new NLPDecode();
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(SemanticRoleLabeler.class, (Object[])new Object[0]);
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            boolean skipSentence = false;
            List tokens = JCasUtil.selectCovered((JCas)jCas, Token.class, (AnnotationFS)sentence);
            List tokenStrings = JCasUtil.toText((Iterable)tokens);
            DEPTree tree = this.clearNlpDecoder.toDEPTree(tokenStrings);
            for (int i = 1; i < tree.size(); ++i) {
                Token token = (Token)tokens.get(i - 1);
                DEPNode node = tree.get(i);
                node.pos = token.getPos();
                node.lemma = token.getLemma();
            }
            HashMap depNodeToID = Maps.newHashMap();
            int nodeId = 1;
            for (DependencyNode depNode : JCasUtil.selectCovered((JCas)jCas, DependencyNode.class, (AnnotationFS)sentence)) {
                if (depNode instanceof TopDependencyNode) {
                    depNodeToID.put(depNode, 0);
                    continue;
                }
                depNodeToID.put(depNode, nodeId);
                ++nodeId;
            }
            for (int i = 0; i < tokens.size(); ++i) {
                Token token = (Token)tokens.get(i);
                DependencyNode casDepNode = (DependencyNode)JCasUtil.selectCovered((JCas)jCas, DependencyNode.class, (AnnotationFS)token).get(0);
                if (casDepNode.getHeadRelations().size() == 0) {
                    skipSentence = true;
                    continue;
                }
                DependencyRelation headRelation = (DependencyRelation)casDepNode.getHeadRelations().get(0);
                DependencyNode head = headRelation.getHead();
                int id = i + 1;
                DEPNode node = tree.get(id);
                int headId = (Integer)depNodeToID.get(head);
                DEPNode headNode = tree.get(headId);
                node.setHead(headNode, headRelation.getRelation());
            }
            if (skipSentence) continue;
            this.predIdentifier.process(tree);
            this.roleSetClassifier.process(tree);
            this.srlabeler.process(tree);
            this.extractSRLInfo(jCas, tokens, tree);
        }
    }

    private void extractSRLInfo(JCas jCas, List<Token> tokens, DEPTree tree) {
        HashMap headIdToPredicate = Maps.newHashMap();
        HashMap predicateArguments = Maps.newHashMap();
        for (int i = 1; i < tree.size(); ++i) {
            DEPNode parserNode = tree.get(i);
            Token token = tokens.get(i - 1);
            List semanticHeads = parserNode.getSHeads();
            if (semanticHeads.isEmpty()) continue;
            for (DEPArc shead : semanticHeads) {
                List args;
                Predicate pred;
                int headId = shead.getNode().id;
                Token headToken = tokens.get(headId - 1);
                if (!headIdToPredicate.containsKey(headId)) {
                    String rolesetId = shead.getNode().getFeat("pb");
                    pred = this.createPredicate(jCas, rolesetId, headToken);
                    headIdToPredicate.put(headId, pred);
                    args = Lists.newArrayList();
                    predicateArguments.put(pred, args);
                } else {
                    pred = (Predicate)headIdToPredicate.get(headId);
                    args = (List)predicateArguments.get(pred);
                }
                args.add(this.createArgument(jCas, shead, token));
            }
        }
        for (Map.Entry entry : predicateArguments.entrySet()) {
            Predicate predicate = (Predicate)entry.getKey();
            List arguments = (List)entry.getValue();
            predicate.setArguments(UIMAUtil.toFSArray((JCas)jCas, (List)arguments));
        }
    }

    private Predicate createPredicate(JCas jCas, String rolesetId, Token token) {
        Predicate pred = new Predicate(jCas, token.getBegin(), token.getEnd());
        pred.setFrameSet(rolesetId);
        pred.addToIndexes();
        return pred;
    }

    private SemanticArgument createArgument(JCas jCas, DEPArc head, Token token) {
        SemanticArgument argument = new SemanticArgument(jCas, token.getBegin(), token.getEnd());
        argument.setLabel(head.getLabel());
        argument.addToIndexes();
        return argument;
    }
}

