/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.clearnlp;

import com.googlecode.clearnlp.component.AbstractComponent;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.engine.EngineGetter;
import com.googlecode.clearnlp.nlp.NLPDecode;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.clearnlp.TokenOps;
import org.uimafit.component.JCasAnnotator_ImplBase;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.util.JCasUtil;

public abstract class MPAnalyzer_ImplBase<TOKEN_TYPE extends Annotation>
extends JCasAnnotator_ImplBase {
    public static final String DEFAULT_DICTIONARY_FILE_NAME = "dictionary-1.2.0.zip";
    public static final String PARAM_LANGUAGE_CODE = ConfigurationParameterFactory.createConfigurationParameterName(MPAnalyzer_ImplBase.class, (String)"languageCode");
    @ConfigurationParameter(description="Language code (default value=en).", defaultValue={"en"})
    private String languageCode;
    public static final String PARAM_DICTIONARY_URI = ConfigurationParameterFactory.createConfigurationParameterName(MPAnalyzer_ImplBase.class, (String)"dictionaryUri");
    @ConfigurationParameter(description="This parameter provides the URI to the morphological analyzer dictionary used for lemmatizing.")
    private URI dictionaryUri;
    public static final String PARAM_WINDOW_CLASS = ConfigurationParameterFactory.createConfigurationParameterName(MPAnalyzer_ImplBase.class, (String)"windowClass");
    private static final String WINDOW_TYPE_DESCRIPTION = "specifies the class type of annotations that will be tokenized. By default, the tokenizer will tokenize a document sentence by sentence.  If you do not want to precede tokenization withsentence segmentation, then a reasonable value for this parameter is 'org.apache.uima.jcas.tcas.DocumentAnnotation'";
    @ConfigurationParameter(description="specifies the class type of annotations that will be tokenized. By default, the tokenizer will tokenize a document sentence by sentence.  If you do not want to precede tokenization withsentence segmentation, then a reasonable value for this parameter is 'org.apache.uima.jcas.tcas.DocumentAnnotation'", defaultValue={"org.cleartk.token.type.Sentence"})
    private Class<? extends Annotation> windowClass;
    private TokenOps<TOKEN_TYPE> tokenOps;
    private AbstractComponent mpAnalyzer;
    private NLPDecode clearNlpDecoder;

    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(MPAnalyzer_ImplBase.class, (Object[])new Object[0]);
    }

    public static AnalysisEngineDescription getDescription(String langCode, URI dictionaryUri) throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(MPAnalyzer_ImplBase.class, (Object[])new Object[]{PARAM_LANGUAGE_CODE, langCode, PARAM_DICTIONARY_URI, dictionaryUri});
    }

    public MPAnalyzer_ImplBase(TokenOps<TOKEN_TYPE> tokenOps) {
        this.tokenOps = tokenOps;
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            URL mpAnalyzerDictionaryURL = this.dictionaryUri == null ? MPAnalyzer_ImplBase.class.getResource(DEFAULT_DICTIONARY_FILE_NAME).toURI().toURL() : this.dictionaryUri.toURL();
            this.mpAnalyzer = EngineGetter.getComponent((InputStream)mpAnalyzerDictionaryURL.openStream(), (String)this.languageCode, (String)"morph");
            this.clearNlpDecoder = new NLPDecode();
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Annotation window : JCasUtil.select((JCas)jCas, this.windowClass)) {
            DEPNode node;
            Annotation token;
            int i;
            List<TOKEN_TYPE> tokens = this.tokenOps.selectTokens(jCas, window);
            List tokenStrings = JCasUtil.toText(tokens);
            DEPTree depTree = this.clearNlpDecoder.toDEPTree(tokenStrings);
            for (i = 1; i < depTree.size(); ++i) {
                token = (Annotation)tokens.get(i - 1);
                node = depTree.get(i);
                node.pos = this.tokenOps.getPos(jCas, token);
            }
            this.mpAnalyzer.process(depTree);
            for (i = 1; i < depTree.size(); ++i) {
                token = (Annotation)tokens.get(i - 1);
                node = depTree.get(i);
                this.tokenOps.setLemma(jCas, token, node.lemma);
            }
        }
    }
}

