/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.clearnlp;

import com.googlecode.clearnlp.component.AbstractComponent;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.engine.EngineGetter;
import com.googlecode.clearnlp.nlp.NLPDecode;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.clearnlp.PosTagger;
import org.cleartk.clearnlp.TokenOps;
import org.uimafit.component.JCasAnnotator_ImplBase;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.util.JCasUtil;

public abstract class PosTagger_ImplBase<TOKEN_TYPE extends Annotation>
extends JCasAnnotator_ImplBase {
    public static final String DEFAULT_MODEL_FILE_NAME = "ontonotes-en-pos-1.3.0.tgz";
    public static final String PARAM_MODEL_URI = ConfigurationParameterFactory.createConfigurationParameterName(PosTagger_ImplBase.class, (String)"modelUri");
    @ConfigurationParameter(description="This parameter provides the URI to the pos tagger model.")
    private URI modelUri;
    public static final String PARAM_LANGUAGE_CODE = ConfigurationParameterFactory.createConfigurationParameterName(PosTagger_ImplBase.class, (String)"languageCode");
    @ConfigurationParameter(description="Language code for the pos tagger (default value=en).", defaultValue={"en"})
    private String languageCode;
    public static final String PARAM_WINDOW_CLASS = ConfigurationParameterFactory.createConfigurationParameterName(PosTagger_ImplBase.class, (String)"windowClass");
    private static final String WINDOW_TYPE_DESCRIPTION = "specifies the class type of annotations that will be tokenized. By default, the tokenizer will tokenize a document sentence by sentence.  If you do not want to precede tokenization withsentence segmentation, then a reasonable value for this parameter is 'org.apache.uima.jcas.tcas.DocumentAnnotation'";
    @ConfigurationParameter(description="specifies the class type of annotations that will be tokenized. By default, the tokenizer will tokenize a document sentence by sentence.  If you do not want to precede tokenization withsentence segmentation, then a reasonable value for this parameter is 'org.apache.uima.jcas.tcas.DocumentAnnotation'", defaultValue={"org.cleartk.token.type.Sentence"})
    private Class<? extends Annotation> windowClass;
    private TokenOps<TOKEN_TYPE> tokenOps;
    private AbstractComponent tagger;
    private NLPDecode clearNlpDecoder;

    public PosTagger_ImplBase(TokenOps<TOKEN_TYPE> tokenOps) {
        this.tokenOps = tokenOps;
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            URL modelURL = this.modelUri == null ? PosTagger.class.getResource(DEFAULT_MODEL_FILE_NAME).toURI().toURL() : this.modelUri.toURL();
            this.tagger = EngineGetter.getComponent((InputStream)modelURL.openStream(), (String)this.languageCode, (String)"pos");
            this.clearNlpDecoder = new NLPDecode();
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Annotation window : JCasUtil.select((JCas)jCas, this.windowClass)) {
            List<TOKEN_TYPE> tokens = this.tokenOps.selectTokens(jCas, window);
            if (tokens.size() <= 0) {
                return;
            }
            List tokenStrings = JCasUtil.toText(tokens);
            DEPTree clearNlpDepTree = this.clearNlpDecoder.toDEPTree(tokenStrings);
            this.tagger.process(clearNlpDepTree);
            String[] posTags = clearNlpDepTree.getPOSTags();
            for (int i = 0; i < tokens.size(); ++i) {
                Annotation token = (Annotation)tokens.get(i);
                this.tokenOps.setPos(jCas, token, posTags[i + 1]);
            }
        }
    }
}

