/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.clearnlp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.googlecode.clearnlp.component.AbstractComponent;
import com.googlecode.clearnlp.dependency.DEPArc;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.engine.EngineGetter;
import com.googlecode.clearnlp.nlp.NLPDecode;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.clearnlp.DependencyOps;
import org.cleartk.clearnlp.SemanticRoleOps;
import org.cleartk.clearnlp.TokenOps;
import org.uimafit.component.JCasAnnotator_ImplBase;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.util.JCasUtil;

public abstract class SemanticRoleLabeler_ImplBase<WINDOW_TYPE extends Annotation, TOKEN_TYPE extends Annotation, DEPENDENCY_NODE_TYPE extends TOP, DEPENDENCY_ROOT_NODE_TYPE extends DEPENDENCY_NODE_TYPE, DEPENDENCY_RELATION_TYPE extends TOP, ARGUMENT_TYPE extends TOP, PREDICATE_TYPE extends TOP>
extends JCasAnnotator_ImplBase {
    public static final String DEFAULT_PRED_ID_MODEL_FILE_NAME = "ontonotes-en-pred-1.3.0.tgz";
    public static final String DEFAULT_ROLESET_MODEL_FILE_NAME = "ontonotes-en-role-1.3.0.tgz";
    public static final String DEFAULT_SRL_MODEL_FILE_NAME = "ontonotes-en-srl-1.3.0.tgz";
    public static final String PARAM_SRL_MODEL_URI = ConfigurationParameterFactory.createConfigurationParameterName(SemanticRoleLabeler_ImplBase.class, (String)"srlModelUri");
    @ConfigurationParameter(description="This parameter provides the URI pointing to the semantic role labeler model.  If none is specified it will use the default ontonotes model.")
    private URI srlModelUri;
    public static final String PARAM_PRED_ID_MODEL_URI = ConfigurationParameterFactory.createConfigurationParameterName(SemanticRoleLabeler_ImplBase.class, (String)"predIdModelUri");
    @ConfigurationParameter(description="This parameter provides the URI pointing to the predicate identifier model.  If none is specified it will use the default ontonotes model.")
    private URI predIdModelUri;
    public static final String PARAM_ROLESET_MODEL_URI = ConfigurationParameterFactory.createConfigurationParameterName(SemanticRoleLabeler_ImplBase.class, (String)"rolesetModelUri");
    @ConfigurationParameter(description="This parameter provides the URI pointing to the role set classifier model.  If none is specified it will use the default ontonotes model.")
    private URI rolesetModelUri;
    public static final String PARAM_LANGUAGE_CODE = ConfigurationParameterFactory.createConfigurationParameterName(SemanticRoleLabeler_ImplBase.class, (String)"languageCode");
    @ConfigurationParameter(description="Language code for the semantic role labeler (default value=en).", defaultValue={"en"})
    private String languageCode;
    public static final String PARAM_WINDOW_CLASS = ConfigurationParameterFactory.createConfigurationParameterName(SemanticRoleLabeler_ImplBase.class, (String)"windowClass");
    private static final String WINDOW_TYPE_DESCRIPTION = "specifies the class type of annotations that will be tokenized. By default, the tokenizer will tokenize a document sentence by sentence.  If you do not want to precede tokenization withsentence segmentation, then a reasonable value for this parameter is 'org.apache.uima.jcas.tcas.DocumentAnnotation'";
    @ConfigurationParameter(description="specifies the class type of annotations that will be tokenized. By default, the tokenizer will tokenize a document sentence by sentence.  If you do not want to precede tokenization withsentence segmentation, then a reasonable value for this parameter is 'org.apache.uima.jcas.tcas.DocumentAnnotation'", defaultValue={"org.cleartk.token.type.Sentence"})
    private Class<? extends WINDOW_TYPE> windowClass;
    private TokenOps<TOKEN_TYPE> tokenOps;
    private DependencyOps<DEPENDENCY_NODE_TYPE, TOKEN_TYPE, DEPENDENCY_ROOT_NODE_TYPE, WINDOW_TYPE, DEPENDENCY_RELATION_TYPE> dependencyOps;
    private SemanticRoleOps<ARGUMENT_TYPE, TOKEN_TYPE, PREDICATE_TYPE, TOKEN_TYPE> srlOps;
    private AbstractComponent predIdentifier;
    private AbstractComponent roleSetClassifier;
    private AbstractComponent srlabeler;
    private NLPDecode clearNlpDecoder;

    public SemanticRoleLabeler_ImplBase(TokenOps<TOKEN_TYPE> tokenOps, DependencyOps<DEPENDENCY_NODE_TYPE, TOKEN_TYPE, DEPENDENCY_ROOT_NODE_TYPE, WINDOW_TYPE, DEPENDENCY_RELATION_TYPE> dependencyOps, SemanticRoleOps<ARGUMENT_TYPE, TOKEN_TYPE, PREDICATE_TYPE, TOKEN_TYPE> srlOps) {
        this.tokenOps = tokenOps;
        this.dependencyOps = dependencyOps;
        this.srlOps = srlOps;
    }

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        try {
            URL predIdModelURL = this.predIdModelUri == null ? SemanticRoleLabeler_ImplBase.class.getResource(DEFAULT_PRED_ID_MODEL_FILE_NAME).toURI().toURL() : this.predIdModelUri.toURL();
            this.predIdentifier = EngineGetter.getComponent((InputStream)predIdModelURL.openStream(), (String)this.languageCode, (String)"pred");
            URL rolesetModelUrl = this.rolesetModelUri == null ? SemanticRoleLabeler_ImplBase.class.getResource(DEFAULT_ROLESET_MODEL_FILE_NAME).toURI().toURL() : this.rolesetModelUri.toURL();
            this.roleSetClassifier = EngineGetter.getComponent((InputStream)rolesetModelUrl.openStream(), (String)this.languageCode, (String)"role");
            URL srlModelURL = this.srlModelUri == null ? SemanticRoleLabeler_ImplBase.class.getResource(DEFAULT_SRL_MODEL_FILE_NAME).toURI().toURL() : this.srlModelUri.toURL();
            this.srlabeler = EngineGetter.getComponent((InputStream)srlModelURL.openStream(), (String)this.languageCode, (String)"srl");
            this.clearNlpDecoder = new NLPDecode();
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(SemanticRoleLabeler_ImplBase.class, (Object[])new Object[0]);
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Annotation window : JCasUtil.select((JCas)jCas, this.windowClass)) {
            boolean skipSentence = false;
            List<TOKEN_TYPE> tokens = this.tokenOps.selectTokens(jCas, window);
            List tokenStrings = JCasUtil.toText(tokens);
            DEPENDENCY_ROOT_NODE_TYPE dependencyRoot = this.dependencyOps.selectRootNode(jCas, window);
            List<DEPENDENCY_NODE_TYPE> dependencyNodes = this.dependencyOps.selectNodes(jCas, window);
            if (dependencyNodes.size() != tokens.size()) {
                throw new IllegalArgumentException(String.format("Expected one dependency node per token; found %d tokens and %d dependency nodes", tokens.size(), dependencyNodes.size()));
            }
            DEPTree tree = this.clearNlpDecoder.toDEPTree(tokenStrings);
            for (int i = 1; i < tree.size(); ++i) {
                Annotation token = (Annotation)tokens.get(i - 1);
                DEPNode node = tree.get(i);
                node.pos = this.tokenOps.getPos(jCas, token);
                node.lemma = this.tokenOps.getLemma(jCas, token);
            }
            HashMap depNodeToID = Maps.newHashMap();
            depNodeToID.put(dependencyRoot, 0);
            int nodeId = 1;
            for (TOP depNode : dependencyNodes) {
                depNodeToID.put(depNode, nodeId);
                ++nodeId;
            }
            for (TOP casDepNode : dependencyNodes) {
                List<DEPENDENCY_RELATION_TYPE> relations = this.dependencyOps.getHeadRelations(jCas, casDepNode);
                if (relations.size() == 0) {
                    skipSentence = true;
                    continue;
                }
                if (relations.size() != 1) {
                    throw new IllegalArgumentException("Expected 1 head, found " + relations.size());
                }
                for (TOP relation : relations) {
                    DEPENDENCY_NODE_TYPE head = this.dependencyOps.getHead(jCas, relation);
                    String label = this.dependencyOps.getLabel(jCas, relation);
                    DEPNode node = tree.get(((Integer)depNodeToID.get(casDepNode)).intValue());
                    DEPNode headNode = tree.get(((Integer)depNodeToID.get(head)).intValue());
                    node.setHead(headNode, label);
                }
            }
            if (skipSentence) continue;
            this.predIdentifier.process(tree);
            this.roleSetClassifier.process(tree);
            this.srlabeler.process(tree);
            this.extractSRLInfo(jCas, tokens, tree);
        }
    }

    private void extractSRLInfo(JCas jCas, List<TOKEN_TYPE> tokens, DEPTree tree) {
        HashMap headIdToPredicate = Maps.newHashMap();
        HashMap predicateArguments = Maps.newHashMap();
        for (int i = 1; i < tree.size(); ++i) {
            DEPNode parserNode = tree.get(i);
            Annotation token = (Annotation)tokens.get(i - 1);
            List semanticHeads = parserNode.getSHeads();
            if (semanticHeads.isEmpty()) continue;
            for (DEPArc shead : semanticHeads) {
                List args;
                Object pred;
                int headId = shead.getNode().id;
                Annotation headToken = (Annotation)tokens.get(headId - 1);
                if (!headIdToPredicate.containsKey(headId)) {
                    String rolesetId = shead.getNode().getFeat("pb");
                    pred = this.srlOps.createPredicate(jCas, headToken, rolesetId);
                    headIdToPredicate.put(headId, pred);
                    args = Lists.newArrayList();
                    predicateArguments.put(pred, args);
                } else {
                    pred = (TOP)headIdToPredicate.get(headId);
                    args = (List)predicateArguments.get(pred);
                }
                args.add(this.srlOps.createArgument(jCas, token, shead.getLabel()));
            }
        }
        for (Map.Entry entry : predicateArguments.entrySet()) {
            TOP predicate = (TOP)entry.getKey();
            List arguments = (List)entry.getValue();
            this.srlOps.setPredicateArguments(jCas, predicate, arguments);
        }
    }
}

