/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.clearnlp;

import com.clearnlp.component.AbstractComponent;
import com.clearnlp.dependency.DEPFeat;
import com.clearnlp.dependency.DEPNode;
import com.clearnlp.dependency.DEPTree;
import com.clearnlp.nlp.NLPGetter;
import com.google.common.annotations.Beta;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.clearnlp.DependencyOps;
import org.cleartk.clearnlp.TokenOps;

@Beta
public abstract class DependencyParser_ImplBase<WINDOW_TYPE extends Annotation, TOKEN_TYPE extends Annotation, DEPENDENCY_NODE_TYPE extends TOP, DEPENDENCY_ROOT_NODE_TYPE extends DEPENDENCY_NODE_TYPE, DEPENDENCY_RELATION_TYPE extends TOP>
extends JCasAnnotator_ImplBase {
    public static final String DEFAULT_MODEL_PATH = "general-en";
    public static final String PARAM_PARSER_MODEL_PATH = "parserModelPath";
    @ConfigurationParameter(name="parserModelPath", mandatory=false, description="This parameter provides the file name of the dependency parser model required by the factory method provided by ClearParserUtil.", defaultValue={"general-en"})
    private String parserModelPath;
    public static final String PARAM_LANGUAGE_CODE = "languageCode";
    @ConfigurationParameter(name="languageCode", mandatory=false, description="Language code for the dependency parser (default value=en).", defaultValue={"en"})
    private String languageCode;
    public static final String PARAM_WINDOW_CLASS = "windowClass";
    private static final String WINDOW_TYPE_DESCRIPTION = "specifies the class type of annotations that will be tokenized. By default, the tokenizer will tokenize a document sentence by sentence.  If you do not want to precede tokenization withsentence segmentation, then a reasonable value for this parameter is 'org.apache.uima.jcas.tcas.DocumentAnnotation'";
    @ConfigurationParameter(name="windowClass", mandatory=false, description="specifies the class type of annotations that will be tokenized. By default, the tokenizer will tokenize a document sentence by sentence.  If you do not want to precede tokenization withsentence segmentation, then a reasonable value for this parameter is 'org.apache.uima.jcas.tcas.DocumentAnnotation'", defaultValue={"org.cleartk.token.type.Sentence"})
    private Class<WINDOW_TYPE> windowClass;
    private TokenOps<TOKEN_TYPE> tokenOps;
    private DependencyOps<DEPENDENCY_NODE_TYPE, TOKEN_TYPE, DEPENDENCY_ROOT_NODE_TYPE, WINDOW_TYPE, DEPENDENCY_RELATION_TYPE> dependencyOps;
    private AbstractComponent parser;

    public DependencyParser_ImplBase(TokenOps<TOKEN_TYPE> tokenOps, DependencyOps<DEPENDENCY_NODE_TYPE, TOKEN_TYPE, DEPENDENCY_ROOT_NODE_TYPE, WINDOW_TYPE, DEPENDENCY_RELATION_TYPE> dependencyOps) {
        this.tokenOps = tokenOps;
        this.dependencyOps = dependencyOps;
    }

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        try {
            this.parser = NLPGetter.getComponent((String)this.parserModelPath, (String)this.languageCode, (String)"dep");
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Annotation window : JCasUtil.select((JCas)jCas, this.windowClass)) {
            List<TOKEN_TYPE> tokens = this.tokenOps.selectTokens(jCas, window);
            DEPTree tree = new DEPTree();
            for (int i = 0; i < tokens.size(); ++i) {
                Annotation token = (Annotation)tokens.get(i);
                String lemma = this.tokenOps.getLemma(jCas, token);
                String pos = this.tokenOps.getPos(jCas, token);
                DEPNode node = new DEPNode(i + 1, token.getCoveredText(), lemma, pos, new DEPFeat());
                tree.add((Object)node);
            }
            this.parser.process(tree);
            this.addTreeToCas(jCas, tree, window, tokens);
        }
    }

    private void addTreeToCas(JCas jCas, DEPTree tree, WINDOW_TYPE window, List<TOKEN_TYPE> tokens) {
        ArrayList<Object> nodes = new ArrayList<Object>(tree.size());
        DEPENDENCY_ROOT_NODE_TYPE rootNode = this.dependencyOps.createRootNode(jCas, window);
        nodes.add(rootNode);
        for (int i = 0; i < tokens.size(); ++i) {
            Annotation token = (Annotation)tokens.get(i);
            nodes.add(this.dependencyOps.createNode(jCas, token));
        }
        HashMultimap headRelations = HashMultimap.create();
        HashMultimap childRelations = HashMultimap.create();
        for (int i = 0; i < tree.size(); ++i) {
            DEPNode dEPNode = tree.get(i);
            if (!dEPNode.hasHead()) continue;
            int headIndex = dEPNode.getHead().id;
            TOP node = (TOP)nodes.get(i);
            TOP headNode = (TOP)nodes.get(headIndex);
            DEPENDENCY_RELATION_TYPE rel = this.dependencyOps.createRelation(jCas, headNode, node, dEPNode.getLabel());
            headRelations.put((Object)node, rel);
            childRelations.put((Object)headNode, rel);
        }
        for (TOP tOP : nodes) {
            this.dependencyOps.setHeadRelations(jCas, tOP, Lists.newArrayList((Iterable)headRelations.get((Object)tOP)));
            this.dependencyOps.setChildRelations(jCas, tOP, Lists.newArrayList((Iterable)childRelations.get((Object)tOP)));
            tOP.addToIndexes();
        }
    }
}

