/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.clearnlp;

import com.clearnlp.component.AbstractComponent;
import com.clearnlp.dependency.DEPNode;
import com.clearnlp.dependency.DEPTree;
import com.clearnlp.nlp.NLPGetter;
import com.google.common.annotations.Beta;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.clearnlp.TokenOps;

@Beta
public abstract class MpAnalyzer_ImplBase<TOKEN_TYPE extends Annotation>
extends JCasAnnotator_ImplBase {
    public static final String DEFAULT_DICTIONARY_FILE_NAME = "dictionary-1.2.0.zip";
    public static final String PARAM_LANGUAGE_CODE = "languageCode";
    @ConfigurationParameter(name="languageCode", mandatory=false, description="Language code (default value=en).", defaultValue={"en"})
    private String languageCode;
    public static final String PARAM_WINDOW_CLASS = "windowClass";
    private static final String WINDOW_TYPE_DESCRIPTION = "specifies the class type of annotations that will be tokenized. By default, the tokenizer will tokenize a document sentence by sentence.  If you do not want to precede tokenization withsentence segmentation, then a reasonable value for this parameter is 'org.apache.uima.jcas.tcas.DocumentAnnotation'";
    @ConfigurationParameter(name="windowClass", mandatory=false, description="specifies the class type of annotations that will be tokenized. By default, the tokenizer will tokenize a document sentence by sentence.  If you do not want to precede tokenization withsentence segmentation, then a reasonable value for this parameter is 'org.apache.uima.jcas.tcas.DocumentAnnotation'", defaultValue={"org.cleartk.token.type.Sentence"})
    private Class<? extends Annotation> windowClass;
    private TokenOps<TOKEN_TYPE> tokenOps;
    private AbstractComponent mpAnalyzer;

    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(MpAnalyzer_ImplBase.class, (Object[])new Object[0]);
    }

    public static AnalysisEngineDescription getDescription(String langCode) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(MpAnalyzer_ImplBase.class, (Object[])new Object[]{PARAM_LANGUAGE_CODE, langCode});
    }

    public MpAnalyzer_ImplBase(TokenOps<TOKEN_TYPE> tokenOps) {
        this.tokenOps = tokenOps;
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.mpAnalyzer = NLPGetter.getComponent((String)"", (String)this.languageCode, (String)"morph");
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Annotation window : JCasUtil.select((JCas)jCas, this.windowClass)) {
            DEPNode node;
            Annotation token;
            int i;
            List<TOKEN_TYPE> tokens = this.tokenOps.selectTokens(jCas, window);
            List tokenStrings = JCasUtil.toText(tokens);
            DEPTree depTree = NLPGetter.toDEPTree((List)tokenStrings);
            for (i = 1; i < depTree.size(); ++i) {
                token = (Annotation)tokens.get(i - 1);
                node = depTree.get(i);
                node.pos = this.tokenOps.getPos(jCas, token);
            }
            this.mpAnalyzer.process(depTree);
            for (i = 1; i < depTree.size(); ++i) {
                token = (Annotation)tokens.get(i - 1);
                node = depTree.get(i);
                this.tokenOps.setLemma(jCas, token, node.lemma);
            }
        }
    }
}

