/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.clearnlp;

import com.google.common.annotations.Beta;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import edu.emory.clir.clearnlp.component.AbstractComponent;
import edu.emory.clir.clearnlp.component.mode.dep.DEPConfiguration;
import edu.emory.clir.clearnlp.component.utils.GlobalLexica;
import edu.emory.clir.clearnlp.component.utils.NLPUtils;
import edu.emory.clir.clearnlp.dependency.DEPFeat;
import edu.emory.clir.clearnlp.dependency.DEPNode;
import edu.emory.clir.clearnlp.dependency.DEPTree;
import edu.emory.clir.clearnlp.util.lang.TLanguage;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.clearnlp.DependencyOps;
import org.cleartk.clearnlp.TokenOps;

@Beta
public abstract class DependencyParser_ImplBase<WINDOW_TYPE extends Annotation, TOKEN_TYPE extends Annotation, DEPENDENCY_NODE_TYPE extends TOP, DEPENDENCY_ROOT_NODE_TYPE extends DEPENDENCY_NODE_TYPE, DEPENDENCY_RELATION_TYPE extends TOP>
extends JCasAnnotator_ImplBase {
    public static final String DEFAULT_MODEL_PATH = "general-en-dep.xz";
    public static final String PARAM_PARSER_MODEL_PATH = "parserModelPath";
    @ConfigurationParameter(name="parserModelPath", mandatory=false, description="This parameter provides the file name of the dependency parser model required by the factory method provided by ClearParserUtil.", defaultValue={"general-en-dep.xz"})
    private String parserModelPath;
    public static final String PARAM_LANGUAGE_CODE = "languageCode";
    @ConfigurationParameter(name="languageCode", mandatory=false, description="Language code for the dependency parser (default value=en).", defaultValue={"ENGLISH"})
    private String languageCode;
    public static final String PARAM_WINDOW_CLASS = "windowClass";
    private static final String WINDOW_TYPE_DESCRIPTION = "specifies the class type of annotations that will be tokenized. By default, the tokenizer will tokenize a document sentence by sentence.  If you do not want to precede tokenization withsentence segmentation, then a reasonable value for this parameter is 'org.apache.uima.jcas.tcas.DocumentAnnotation'";
    @ConfigurationParameter(name="windowClass", mandatory=false, description="specifies the class type of annotations that will be tokenized. By default, the tokenizer will tokenize a document sentence by sentence.  If you do not want to precede tokenization withsentence segmentation, then a reasonable value for this parameter is 'org.apache.uima.jcas.tcas.DocumentAnnotation'", defaultValue={"org.cleartk.token.type.Sentence"})
    private Class<WINDOW_TYPE> windowClass;
    private TokenOps<TOKEN_TYPE> tokenOps;
    private DependencyOps<DEPENDENCY_NODE_TYPE, TOKEN_TYPE, DEPENDENCY_ROOT_NODE_TYPE, WINDOW_TYPE, DEPENDENCY_RELATION_TYPE> dependencyOps;
    private AbstractComponent parser;

    public DependencyParser_ImplBase(TokenOps<TOKEN_TYPE> tokenOps, DependencyOps<DEPENDENCY_NODE_TYPE, TOKEN_TYPE, DEPENDENCY_ROOT_NODE_TYPE, WINDOW_TYPE, DEPENDENCY_RELATION_TYPE> dependencyOps) {
        this.tokenOps = tokenOps;
        this.dependencyOps = dependencyOps;
    }

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        ArrayList<String> paths = new ArrayList<String>();
        paths.add("brown-rcv1.clean.tokenized-CoNLL03.txt-c1000-freq1.txt.xz");
        GlobalLexica.initDistributionalSemanticsWords(paths);
        this.parser = NLPUtils.getDEPParser((TLanguage)TLanguage.getType((String)this.languageCode), (String)this.parserModelPath, (DEPConfiguration)new DEPConfiguration("root"));
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Annotation window : JCasUtil.select((JCas)jCas, this.windowClass)) {
            List<TOKEN_TYPE> tokens = this.tokenOps.selectTokens(jCas, window);
            DEPTree tree = new DEPTree(tokens.size());
            for (int i = 0; i < tokens.size(); ++i) {
                Annotation token = (Annotation)tokens.get(i);
                String lemma = this.tokenOps.getLemma(jCas, token);
                String pos = this.tokenOps.getPos(jCas, token);
                DEPNode node = new DEPNode(i + 1, token.getCoveredText(), lemma, pos, new DEPFeat());
                tree.add(node);
            }
            this.parser.process(tree);
            this.addTreeToCas(jCas, tree, window, tokens);
        }
    }

    private void addTreeToCas(JCas jCas, DEPTree tree, WINDOW_TYPE window, List<TOKEN_TYPE> tokens) {
        ArrayList<Object> nodes = new ArrayList<Object>(tree.size());
        DEPENDENCY_ROOT_NODE_TYPE rootNode = this.dependencyOps.createRootNode(jCas, window);
        nodes.add(rootNode);
        for (int i = 0; i < tokens.size(); ++i) {
            Annotation token = (Annotation)tokens.get(i);
            nodes.add(this.dependencyOps.createNode(jCas, token));
        }
        HashMultimap headRelations = HashMultimap.create();
        HashMultimap childRelations = HashMultimap.create();
        for (int i = 0; i < tree.size(); ++i) {
            DEPNode dEPNode = tree.get(i);
            if (!dEPNode.hasHead()) continue;
            int headIndex = dEPNode.getHead().getID();
            TOP node = (TOP)nodes.get(i);
            TOP headNode = (TOP)nodes.get(headIndex);
            DEPENDENCY_RELATION_TYPE rel = this.dependencyOps.createRelation(jCas, headNode, node, dEPNode.getLabel());
            headRelations.put((Object)node, rel);
            childRelations.put((Object)headNode, rel);
        }
        for (TOP tOP : nodes) {
            this.dependencyOps.setHeadRelations(jCas, tOP, Lists.newArrayList((Iterable)headRelations.get((Object)tOP)));
            this.dependencyOps.setChildRelations(jCas, tOP, Lists.newArrayList((Iterable)childRelations.get((Object)tOP)));
            tOP.addToIndexes();
        }
    }
}

