/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.clearnlp;

import com.google.common.annotations.Beta;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.emory.clir.clearnlp.component.AbstractComponent;
import edu.emory.clir.clearnlp.component.mode.srl.SRLConfiguration;
import edu.emory.clir.clearnlp.component.utils.GlobalLexica;
import edu.emory.clir.clearnlp.component.utils.NLPUtils;
import edu.emory.clir.clearnlp.dependency.DEPNode;
import edu.emory.clir.clearnlp.dependency.DEPTree;
import edu.emory.clir.clearnlp.util.arc.SRLArc;
import edu.emory.clir.clearnlp.util.lang.TLanguage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.clearnlp.DependencyOps;
import org.cleartk.clearnlp.SemanticRoleOps;
import org.cleartk.clearnlp.TokenOps;

@Beta
public abstract class SemanticRoleLabeler_ImplBase<WINDOW_TYPE extends Annotation, TOKEN_TYPE extends Annotation, DEPENDENCY_NODE_TYPE extends TOP, DEPENDENCY_ROOT_NODE_TYPE extends DEPENDENCY_NODE_TYPE, DEPENDENCY_RELATION_TYPE extends TOP, ARGUMENT_TYPE extends TOP, PREDICATE_TYPE extends TOP>
extends JCasAnnotator_ImplBase {
    public static final String DEFAULT_SRL_MODEL_PATH = "general-en-srl.xz";
    public static final String PARAM_SRL_MODEL_PATH = "srlModelPath";
    @ConfigurationParameter(name="srlModelPath", mandatory=false, description="This parameter provides the path pointing to the semantic role labeler model.  If none is specified it will use the default ontonotes model.", defaultValue={"general-en-srl.xz"})
    private String srlModelPath;
    public static final String PARAM_LANGUAGE_CODE = "languageCode";
    @ConfigurationParameter(name="languageCode", mandatory=false, description="Language code for the semantic role labeler (default value=en).", defaultValue={"ENGLISH"})
    private TLanguage languageCode;
    public static final String PARAM_WINDOW_CLASS = "windowClass";
    private static final String WINDOW_TYPE_DESCRIPTION = "specifies the class type of annotations that will be tokenized. By default, the tokenizer will tokenize a document sentence by sentence.  If you do not want to precede tokenization withsentence segmentation, then a reasonable value for this parameter is 'org.apache.uima.jcas.tcas.DocumentAnnotation'";
    @ConfigurationParameter(name="windowClass", mandatory=false, description="specifies the class type of annotations that will be tokenized. By default, the tokenizer will tokenize a document sentence by sentence.  If you do not want to precede tokenization withsentence segmentation, then a reasonable value for this parameter is 'org.apache.uima.jcas.tcas.DocumentAnnotation'", defaultValue={"org.cleartk.token.type.Sentence"})
    private Class<? extends WINDOW_TYPE> windowClass;
    private TokenOps<TOKEN_TYPE> tokenOps;
    private DependencyOps<DEPENDENCY_NODE_TYPE, TOKEN_TYPE, DEPENDENCY_ROOT_NODE_TYPE, WINDOW_TYPE, DEPENDENCY_RELATION_TYPE> dependencyOps;
    private SemanticRoleOps<ARGUMENT_TYPE, TOKEN_TYPE, PREDICATE_TYPE, TOKEN_TYPE> srlOps;
    private AbstractComponent srlabeler;

    public SemanticRoleLabeler_ImplBase(TokenOps<TOKEN_TYPE> tokenOps, DependencyOps<DEPENDENCY_NODE_TYPE, TOKEN_TYPE, DEPENDENCY_ROOT_NODE_TYPE, WINDOW_TYPE, DEPENDENCY_RELATION_TYPE> dependencyOps, SemanticRoleOps<ARGUMENT_TYPE, TOKEN_TYPE, PREDICATE_TYPE, TOKEN_TYPE> srlOps) {
        this.tokenOps = tokenOps;
        this.dependencyOps = dependencyOps;
        this.srlOps = srlOps;
    }

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        ArrayList<String> paths = new ArrayList<String>();
        paths.add("brown-rcv1.clean.tokenized-CoNLL03.txt-c1000-freq1.txt.xz");
        GlobalLexica.initDistributionalSemanticsWords(paths);
        try {
            this.srlabeler = NLPUtils.getSRLabeler((TLanguage)this.languageCode, (String)this.srlModelPath, (SRLConfiguration)new SRLConfiguration(4, 3));
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(SemanticRoleLabeler_ImplBase.class, (Object[])new Object[0]);
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Annotation window : JCasUtil.select((JCas)jCas, this.windowClass)) {
            boolean skipSentence = false;
            List<TOKEN_TYPE> tokens = this.tokenOps.selectTokens(jCas, window);
            List tokenStrings = JCasUtil.toText(tokens);
            DEPENDENCY_ROOT_NODE_TYPE dependencyRoot = this.dependencyOps.selectRootNode(jCas, window);
            List<DEPENDENCY_NODE_TYPE> dependencyNodes = this.dependencyOps.selectNodes(jCas, window);
            if (dependencyNodes.size() != tokens.size()) {
                throw new IllegalArgumentException(String.format("Expected one dependency node per token; found %d tokens and %d dependency nodes", tokens.size(), dependencyNodes.size()));
            }
            DEPTree tree = new DEPTree(tokenStrings);
            for (int i = 1; i < tree.size(); ++i) {
                Annotation token = (Annotation)tokens.get(i - 1);
                DEPNode node = tree.get(i);
                node.setPOSTag(this.tokenOps.getPos(jCas, token));
                node.setLemma(this.tokenOps.getLemma(jCas, token));
            }
            HashMap depNodeToID = Maps.newHashMap();
            depNodeToID.put(dependencyRoot, 0);
            int nodeId = 1;
            for (TOP depNode : dependencyNodes) {
                depNodeToID.put(depNode, nodeId);
                ++nodeId;
            }
            for (TOP casDepNode : dependencyNodes) {
                List<DEPENDENCY_RELATION_TYPE> relations = this.dependencyOps.getHeadRelations(jCas, casDepNode);
                if (relations.size() == 0) {
                    skipSentence = true;
                    continue;
                }
                if (relations.size() != 1) {
                    throw new IllegalArgumentException("Expected 1 head, found " + relations.size());
                }
                for (TOP relation : relations) {
                    DEPENDENCY_NODE_TYPE head = this.dependencyOps.getHead(jCas, relation);
                    String label = this.dependencyOps.getLabel(jCas, relation);
                    DEPNode node = tree.get(((Integer)depNodeToID.get(casDepNode)).intValue());
                    DEPNode headNode = tree.get(((Integer)depNodeToID.get(head)).intValue());
                    node.setHead(headNode, label);
                }
            }
            if (skipSentence) continue;
            this.srlabeler.process(tree);
            this.extractSRLInfo(jCas, tokens, tree);
        }
    }

    private void extractSRLInfo(JCas jCas, List<TOKEN_TYPE> tokens, DEPTree tree) {
        HashMap headIdToPredicate = Maps.newHashMap();
        HashMap predicateArguments = Maps.newHashMap();
        for (int i = 1; i < tree.size(); ++i) {
            DEPNode parserNode = tree.get(i);
            Annotation token = (Annotation)tokens.get(i - 1);
            List semanticHeads = parserNode.getSemanticHeadArcList();
            if (semanticHeads.isEmpty()) continue;
            for (SRLArc shead : semanticHeads) {
                List args;
                Object pred;
                int headId = ((DEPNode)shead.getNode()).getID();
                Annotation headToken = (Annotation)tokens.get(headId - 1);
                if (!headIdToPredicate.containsKey(headId)) {
                    String rolesetId = ((DEPNode)shead.getNode()).getFeat("pb");
                    pred = this.srlOps.createPredicate(jCas, headToken, rolesetId);
                    headIdToPredicate.put(headId, pred);
                    args = Lists.newArrayList();
                    predicateArguments.put(pred, args);
                } else {
                    pred = (TOP)headIdToPredicate.get(headId);
                    args = (List)predicateArguments.get(pred);
                }
                args.add(this.srlOps.createArgument(jCas, token, shead.getLabel()));
            }
        }
        for (Map.Entry entry : predicateArguments.entrySet()) {
            TOP predicate = (TOP)entry.getKey();
            List arguments = (List)entry.getValue();
            this.srlOps.setPredicateArguments(jCas, predicate, arguments);
        }
    }
}

