/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.clearnlp;

import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.clearnlp.CleartkSentenceOps;
import org.cleartk.clearnlp.CleartkTokenOps;
import org.cleartk.clearnlp.SentenceOps;
import org.cleartk.clearnlp.TokenOps;
import org.cleartk.clearnlp.Tokenizer_ImplBase;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;

public class Tokenizer
extends Tokenizer_ImplBase<Token, Sentence> {
    private CleartkTokenOps tokenOps;
    private CleartkSentenceOps sentenceOps;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.tokenOps = new CleartkTokenOps();
        this.sentenceOps = new CleartkSentenceOps();
    }

    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return Tokenizer.getTokenizerDescription("ENGLISH");
    }

    public static AnalysisEngineDescription getTokenizerDescription(String languageCode) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(Tokenizer.class, (Object[])new Object[]{"languageCode", languageCode, "windowClass", "org.cleartk.token.type.Sentence"});
    }

    public static AnalysisEngineDescription getSentenceSegmenterAndTokenizerDescription(String languageCode) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(Tokenizer.class, (Object[])new Object[]{"languageCode", languageCode, "segmentSentences", true});
    }

    public static AnalysisEngineDescription getDescription(String languageCode) throws ResourceInitializationException {
        return Tokenizer.getTokenizerDescription(languageCode);
    }

    @Override
    protected TokenOps<Token> getTokenOps() {
        return this.tokenOps;
    }

    @Override
    protected SentenceOps<Sentence> getSentenceOps() {
        return this.sentenceOps;
    }
}

