/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.corpus;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.cleartk.timeml.type.Anchor;
import org.cleartk.timeml.type.DocumentCreationTime;
import org.cleartk.timeml.type.Event;
import org.cleartk.timeml.type.TemporalLink;
import org.cleartk.timeml.type.Text;
import org.cleartk.timeml.type.Time;
import org.cleartk.timeml.util.TimeMLUtil;
import org.cleartk.token.type.Sentence;
import org.cleartk.util.ViewURIUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.uimafit.component.JCasAnnotator_ImplBase;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.descriptor.SofaCapability;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.factory.ConfigurationParameterFactory;

@SofaCapability(inputSofas={"TimeMLView", "_InitialView"})
public class TimeMLGoldAnnotator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_LOAD_TLINKS = ConfigurationParameterFactory.createConfigurationParameterName(TimeMLGoldAnnotator.class, (String)"loadTlinks");
    @ConfigurationParameter(description="when false indicates that annotation should not be created for TLINKs (though annotations will still be created for TIMEX3s, EVENTs, etc.).", defaultValue={"true"})
    private boolean loadTlinks;

    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(TimeMLGoldAnnotator.class, (Object[])new Object[0]);
    }

    public static AnalysisEngineDescription getDescriptionNoTLINKs() throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(TimeMLGoldAnnotator.class, (Object[])new Object[]{PARAM_LOAD_TLINKS, false});
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Element root;
        JCas initialView;
        JCas timemlView;
        try {
            timemlView = jCas.getView("TimeMLView");
            initialView = jCas.getView("_InitialView");
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        String timeML = timemlView.getDocumentText();
        SAXBuilder builder = new SAXBuilder();
        builder.setDTDHandler(null);
        try {
            Document doc = builder.build((Reader)new StringReader(timeML));
            root = doc.getRootElement();
        }
        catch (JDOMException e) {
            this.getContext().getLogger().log(Level.SEVERE, "problem parsing document: " + ViewURIUtil.getURI((JCas)jCas));
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        StringBuffer textBuffer = new StringBuffer();
        HashMap<String, Anchor> anchors = new HashMap<String, Anchor>();
        HashMap<Time, String> anchorTimeIDs = new HashMap<Time, String>();
        ArrayList<Element> makeInstances = new ArrayList<Element>();
        HashMap<TemporalLink, String> tlinkSourceIDs = new HashMap<TemporalLink, String>();
        HashMap<TemporalLink, String> tlinkTargetIDs = new HashMap<TemporalLink, String>();
        this.addAnnotations(initialView, root, textBuffer, anchors, anchorTimeIDs, makeInstances, tlinkSourceIDs, tlinkTargetIDs);
        initialView.setDocumentText(textBuffer.toString());
        for (Element makeInstance : makeInstances) {
            String eventID = makeInstance.getAttributeValue("eventID");
            String eventInstanceID = makeInstance.getAttributeValue("eiid");
            Event event = (Event)this.getAnchor(jCas, anchors, eventID);
            anchors.put(eventInstanceID, (Anchor)event);
            eventInstanceID = event.getEventInstanceID();
            if (eventInstanceID == null) {
                TimeMLUtil.copyAttributes(makeInstance, (Annotation)event, jCas);
                continue;
            }
            TimeMLUtil.removeInconsistentAttributes(makeInstance, (Annotation)event, jCas);
            event.setId(eventID);
            event.setEventInstanceID(eventInstanceID);
        }
        for (Time time : anchorTimeIDs.keySet()) {
            Time anchorTime = (Time)this.getAnchor(jCas, anchors, (String)anchorTimeIDs.get(time));
            time.setAnchorTime(anchorTime);
        }
        for (TemporalLink tlink : tlinkSourceIDs.keySet()) {
            tlink.setSource(this.getAnchor(jCas, anchors, (String)tlinkSourceIDs.get(tlink)));
            tlink.setTarget(this.getAnchor(jCas, anchors, (String)tlinkTargetIDs.get(tlink)));
        }
    }

    private void addAnnotations(JCas jCas, Element element, StringBuffer textBuffer, Map<String, Anchor> anchors, Map<Time, String> anchorTimeIDs, List<Element> makeInstances, Map<TemporalLink, String> tlinkSourceIDs, Map<TemporalLink, String> tlinkTargetIDs) throws AnalysisEngineProcessException {
        int startOffset = textBuffer.length();
        for (Content content : element.getContent()) {
            if (content instanceof org.jdom2.Text) {
                textBuffer.append(((org.jdom2.Text)content).getText());
                continue;
            }
            if (!(content instanceof Element)) continue;
            this.addAnnotations(jCas, (Element)content, textBuffer, anchors, anchorTimeIDs, makeInstances, tlinkSourceIDs, tlinkTargetIDs);
        }
        int endOffset = textBuffer.length();
        if (element.getName().equals("TIMEX3")) {
            String funcInDoc = element.getAttributeValue("functionInDocument");
            boolean isCreationTime = funcInDoc != null && funcInDoc.equals("CREATION_TIME");
            DocumentCreationTime time = isCreationTime ? new DocumentCreationTime(jCas, startOffset, endOffset) : new Time(jCas, startOffset, endOffset);
            TimeMLUtil.copyAttributes(element, (Annotation)time, jCas);
            String anchorTimeID = element.getAttributeValue("anchorTimeID");
            if (anchorTimeID != null) {
                anchorTimeIDs.put((Time)time, anchorTimeID);
            }
            anchors.put(time.getId(), (Anchor)time);
            time.addToIndexes();
        } else if (element.getName().equals("EVENT")) {
            Event event = new Event(jCas, startOffset, endOffset);
            TimeMLUtil.copyAttributes(element, (Annotation)event, jCas);
            anchors.put(event.getId(), (Anchor)event);
            event.addToIndexes();
        } else if (element.getName().equals("MAKEINSTANCE")) {
            makeInstances.add(element);
        } else if (element.getName().equals("TLINK") && this.loadTlinks) {
            TemporalLink temporalLink = new TemporalLink(jCas, startOffset, endOffset);
            TimeMLUtil.copyAttributes(element, (Annotation)temporalLink, jCas);
            String sourceID = this.getOneOf(element, "eventInstanceID", "eventID", "timeID");
            String targetID = this.getOneOf(element, "relatedToEventInstance", "relatedToEvent", "relatedToTime");
            tlinkSourceIDs.put(temporalLink, sourceID);
            tlinkTargetIDs.put(temporalLink, targetID);
            temporalLink.addToIndexes();
        } else if (element.getName().equals("TEXT")) {
            Text text = new Text(jCas, startOffset, endOffset);
            text.addToIndexes();
        } else if (element.getName().toLowerCase().equals("s")) {
            Sentence sentence = new Sentence(jCas, startOffset, endOffset);
            sentence.addToIndexes();
        }
    }

    private String getOneOf(Element element, String ... attributeNames) {
        for (String name : attributeNames) {
            String result = element.getAttributeValue(name);
            if (result == null) continue;
            return result;
        }
        throw new RuntimeException(String.format("unable to find in %s any of the following attributes: %s", element, Arrays.asList(attributeNames)));
    }

    private Anchor getAnchor(JCas jCas, Map<String, Anchor> anchors, String id) throws AnalysisEngineProcessException {
        Anchor anchor = anchors.get(id);
        if (anchor == null) {
            throw new RuntimeException(String.format("%s: no anchor for id %s", ViewURIUtil.getURI((JCas)jCas), id));
        }
        return anchor;
    }

    public void setLoadTlinks(boolean loadTLINKs) {
        this.loadTlinks = loadTLINKs;
    }
}

