/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.tlink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.util.Level;
import org.cleartk.classifier.CleartkAnnotator;
import org.cleartk.classifier.CleartkProcessingException;
import org.cleartk.classifier.Instance;
import org.cleartk.classifier.feature.extractor.BetweenAnnotationsFeatureExtractor;
import org.cleartk.classifier.feature.extractor.simple.NamingExtractor;
import org.cleartk.classifier.feature.extractor.simple.SimpleFeatureExtractor;
import org.cleartk.syntax.constituent.type.TreebankNode;
import org.cleartk.syntax.constituent.type.TreebankNodeUtil;
import org.cleartk.timeml.type.Anchor;
import org.cleartk.timeml.type.TemporalLink;
import org.cleartk.token.type.Sentence;
import org.uimafit.util.JCasUtil;

public abstract class TemporalLinkAnnotator_ImplBase<SOURCE extends Anchor, TARGET extends Anchor>
extends CleartkAnnotator<String> {
    private Class<SOURCE> sourceClass;
    private Class<TARGET> targetClass;
    private Set<String> trainingRelationTypes;
    protected List<SimpleFeatureExtractor> sourceExtractors;
    protected List<SimpleFeatureExtractor> targetExtractors;
    protected List<BetweenAnnotationsFeatureExtractor> betweenExtractors;

    public TemporalLinkAnnotator_ImplBase(Class<SOURCE> sourceClass, Class<TARGET> targetClass, String ... trainingRelationTypes) {
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
        this.trainingRelationTypes = new HashSet<String>(Arrays.asList(trainingRelationTypes));
        this.sourceExtractors = new ArrayList<SimpleFeatureExtractor>();
        this.targetExtractors = new ArrayList<SimpleFeatureExtractor>();
        this.betweenExtractors = new ArrayList<BetweenAnnotationsFeatureExtractor>();
    }

    protected void setSourceExtractors(List<SimpleFeatureExtractor> extractors) {
        this.sourceExtractors = new ArrayList<SimpleFeatureExtractor>();
        for (SimpleFeatureExtractor extractor : extractors) {
            this.sourceExtractors.add((SimpleFeatureExtractor)new NamingExtractor("Source", extractor));
        }
    }

    protected void setTargetExtractors(List<SimpleFeatureExtractor> extractors) {
        this.targetExtractors = new ArrayList<SimpleFeatureExtractor>();
        for (SimpleFeatureExtractor extractor : extractors) {
            this.targetExtractors.add((SimpleFeatureExtractor)new NamingExtractor("Target", extractor));
        }
    }

    protected void setBetweenExtractors(List<BetweenAnnotationsFeatureExtractor> extractors) {
        this.betweenExtractors = extractors;
    }

    protected Map<SOURCE, Map<TARGET, TemporalLink>> getLinks(JCas jCas) {
        HashMap links = new HashMap();
        if (this.isTraining()) {
            for (TemporalLink tlink : JCasUtil.select((JCas)jCas, TemporalLink.class)) {
                Anchor target;
                Anchor source;
                try {
                    source = (Anchor)this.sourceClass.cast(tlink.getSource());
                }
                catch (ClassCastException e) {
                    String message = "Expected all sources to be of type %s, found %s";
                    throw new RuntimeException(String.format(message, this.sourceClass, tlink.getSource()));
                }
                try {
                    target = (Anchor)this.targetClass.cast(tlink.getTarget());
                }
                catch (ClassCastException e) {
                    String message = "Expected all targets to be of type %s, found %s";
                    throw new RuntimeException(String.format(message, this.targetClass, tlink.getSource()));
                }
                if (!links.containsKey(source)) {
                    links.put(source, new HashMap());
                }
                if (((Map)links.get(source)).containsKey(target)) {
                    String message = "Duplicate link between source %s and target %s";
                    throw new RuntimeException(String.format(message, source.getId(), target.getId()));
                }
                ((Map)links.get(source)).put(target, tlink);
            }
        }
        return links;
    }

    protected void processLink(SOURCE source, TARGET target, Map<SOURCE, Map<TARGET, TemporalLink>> links, JCas jCas) throws CleartkProcessingException {
        ArrayList features = new ArrayList();
        for (SimpleFeatureExtractor simpleFeatureExtractor : this.sourceExtractors) {
            features.addAll(simpleFeatureExtractor.extract(jCas, source));
        }
        for (SimpleFeatureExtractor simpleFeatureExtractor : this.targetExtractors) {
            features.addAll(simpleFeatureExtractor.extract(jCas, target));
        }
        for (BetweenAnnotationsFeatureExtractor betweenAnnotationsFeatureExtractor : this.betweenExtractors) {
            features.addAll(betweenAnnotationsFeatureExtractor.extractBetween(jCas, source, target));
        }
        if (this.isTraining()) {
            if (links.containsKey(source) && links.get(source).containsKey(target)) {
                String relation;
                TemporalLink link = null;
                Map<TARGET, TemporalLink> map = links.get(source);
                if (map != null) {
                    link = map.remove(target);
                    if (map.isEmpty()) {
                        links.remove(source);
                    }
                }
                if (link != null && this.trainingRelationTypes.contains(relation = link.getRelationType())) {
                    this.dataWriter.write(new Instance((Object)relation, features));
                }
            }
        } else {
            String relation = (String)this.classifier.classify(features);
            int n = jCas.getDocumentText().length();
            TemporalLink tlink = new TemporalLink(jCas, n, n);
            tlink.setSource(source);
            tlink.setTarget(target);
            tlink.setRelationType(relation);
            tlink.addToIndexes();
        }
    }

    protected void logSkippedLinks(JCas jCas, Map<SOURCE, Map<TARGET, TemporalLink>> links) {
        if (!links.isEmpty()) {
            int count = 0;
            for (Map<TARGET, TemporalLink> targetLinks : links.values()) {
                count += targetLinks.size();
            }
            HashMap<Anchor, Sentence> sentences = new HashMap<Anchor, Sentence>();
            HashMap<Sentence, Integer> sentenceIndexes = new HashMap<Sentence, Integer>();
            int index = 0;
            for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
                sentenceIndexes.put(sentence, index);
                ++index;
                for (Anchor source : JCasUtil.selectCovered((JCas)jCas, this.sourceClass, (AnnotationFS)sentence)) {
                    sentences.put(source, sentence);
                }
                for (Anchor target : JCasUtil.selectCovered((JCas)jCas, this.targetClass, (AnnotationFS)sentence)) {
                    sentences.put(target, sentence);
                }
            }
            StringBuilder errorBuilder = new StringBuilder();
            errorBuilder.append("Missed ").append(count).append(" TLINK(s)\n");
            ArrayList<SOURCE> sources = new ArrayList<SOURCE>(links.keySet());
            Collections.sort(sources, new Comparator<SOURCE>(){

                @Override
                public int compare(SOURCE source1, SOURCE source2) {
                    return source1.getBegin() - source2.getBegin();
                }
            });
            for (Anchor source : sources) {
                for (Anchor target : links.get(source).keySet()) {
                    TemporalLink link = links.get(source).get(target);
                    Sentence sent1 = (Sentence)sentences.get(source);
                    Sentence sent2 = (Sentence)sentences.get(target);
                    errorBuilder.append(String.format("%s(%s, %s)\n%d: %s\n%d: %s\n", link.getRelationType(), source.getCoveredText(), target.getCoveredText(), sentenceIndexes.get(sent1), sent1.getCoveredText(), sentenceIndexes.get(sent2), sent2.getCoveredText()));
                }
            }
            this.getContext().getLogger().log(Level.FINE, errorBuilder.toString());
        }
    }

    protected static String noLeavesPath(TreebankNodeUtil.TreebankNodePath path) {
        if (path.getCommonAncestor() == null) {
            return null;
        }
        ArrayList<String> sourceTypes = new ArrayList<String>();
        for (TreebankNode node : path.getSourceToAncestorPath()) {
            if (node.getLeaf()) continue;
            sourceTypes.add(node.getNodeType());
        }
        ArrayList<String> targetTypes = new ArrayList<String>();
        for (TreebankNode node : path.getTargetToAncestorPath()) {
            if (node.getLeaf()) continue;
            targetTypes.add(node.getNodeType());
        }
        Collections.reverse(targetTypes);
        StringBuilder builder = new StringBuilder();
        for (String type : sourceTypes) {
            builder.append(type).append('>');
        }
        builder.append(path.getCommonAncestor().getNodeType());
        for (String type : targetTypes) {
            builder.append('<').append(type);
        }
        return builder.toString();
    }
}

