/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.tlink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.classifier.feature.extractor.simple.SimpleFeatureExtractor;
import org.cleartk.classifier.feature.extractor.simple.TypePathExtractor;
import org.cleartk.classifier.opennlp.MaxentStringOutcomeDataWriter;
import org.cleartk.syntax.constituent.type.TreebankNode;
import org.cleartk.syntax.constituent.type.TreebankNodeUtil;
import org.cleartk.timeml.tlink.TemporalLinkAnnotator_ImplBase;
import org.cleartk.timeml.type.Event;
import org.cleartk.timeml.util.CleartkInternalModelFactory;
import org.cleartk.token.type.Sentence;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.util.JCasUtil;

public class TemporalLinkMainEventToNextSentenceMainEventAnnotator
extends TemporalLinkAnnotator_ImplBase<Event, Event> {
    public static final CleartkInternalModelFactory FACTORY = new CleartkInternalModelFactory(){

        @Override
        public Class<?> getAnnotatorClass() {
            return TemporalLinkMainEventToNextSentenceMainEventAnnotator.class;
        }

        @Override
        public Class<?> getDataWriterClass() {
            return MaxentStringOutcomeDataWriter.class;
        }

        @Override
        public AnalysisEngineDescription getBaseDescription() throws ResourceInitializationException {
            return AnalysisEngineFactory.createPrimitiveDescription(TemporalLinkMainEventToNextSentenceMainEventAnnotator.class, (Object[])new Object[0]);
        }
    };

    public TemporalLinkMainEventToNextSentenceMainEventAnnotator() {
        super(Event.class, Event.class, "BEFORE", "OVERLAP", "AFTER");
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        List<SimpleFeatureExtractor> extractors = Arrays.asList(new TypePathExtractor(Event.class, "tense"), new TypePathExtractor(Event.class, "aspect"), new TypePathExtractor(Event.class, "eventClass"));
        this.setSourceExtractors(extractors);
        this.setTargetExtractors(extractors);
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Sentence prev;
        Map links = this.getLinks(jCas);
        Iterator sentences = JCasUtil.select((JCas)jCas, Sentence.class).iterator();
        Sentence sentence = prev = sentences.hasNext() ? (Sentence)sentences.next() : null;
        while (sentences.hasNext()) {
            Sentence curr = (Sentence)sentences.next();
            Event source = this.getMainEvent(jCas, prev);
            Event target = this.getMainEvent(jCas, curr);
            if (source != null && target != null) {
                this.processLink(source, target, links, jCas);
            }
            prev = curr;
        }
        this.logSkippedLinks(jCas, links);
    }

    private Event getMainEvent(JCas jCas, Sentence sentence) {
        Integer minDepth = null;
        HashMap depthEvents = new HashMap();
        for (Event event : JCasUtil.selectCovered((JCas)jCas, Event.class, (AnnotationFS)sentence)) {
            Integer depth;
            TreebankNode node = TreebankNodeUtil.selectMatchingLeaf((JCas)jCas, (Annotation)event);
            Integer n = depth = node == null ? null : Integer.valueOf(TreebankNodeUtil.getDepth((TreebankNode)node));
            if (!depthEvents.containsKey(depth)) {
                depthEvents.put(depth, new ArrayList());
            }
            ((List)depthEvents.get(depth)).add(event);
            if (depth == null || minDepth != null && depth >= minDepth) continue;
            minDepth = depth;
        }
        if (depthEvents.isEmpty()) {
            return null;
        }
        List events = (List)depthEvents.get(minDepth);
        return (Event)events.get(events.size() - 1);
    }
}

