/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml;

import java.io.File;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.cleartk.syntax.opennlp.ParserAnnotator;
import org.cleartk.syntax.opennlp.PosTaggerAnnotator;
import org.cleartk.syntax.opennlp.SentenceAnnotator;
import org.cleartk.timeml.corpus.TimeMLWriter;
import org.cleartk.timeml.event.EventAnnotator;
import org.cleartk.timeml.event.EventAspectAnnotator;
import org.cleartk.timeml.event.EventClassAnnotator;
import org.cleartk.timeml.event.EventModalityAnnotator;
import org.cleartk.timeml.event.EventPolarityAnnotator;
import org.cleartk.timeml.event.EventTenseAnnotator;
import org.cleartk.timeml.time.TimeAnnotator;
import org.cleartk.timeml.time.TimeTypeAnnotator;
import org.cleartk.timeml.tlink.TemporalLinkEventToSameSentenceTimeAnnotator;
import org.cleartk.timeml.tlink.TemporalLinkMainEventToNextSentenceMainEventAnnotator;
import org.cleartk.timeml.tlink.VerbClauseTemporalAnnotator;
import org.cleartk.token.stem.snowball.DefaultSnowballStemmer;
import org.cleartk.token.tokenizer.TokenAnnotator;
import org.cleartk.util.cr.FilesCollectionReader;
import org.uimafit.factory.UimaContextFactory;
import org.uimafit.pipeline.SimplePipeline;

public class TimeMLAnnotate {
    private static void error(String message) throws Exception {
        Logger logger = UimaContextFactory.createUimaContext((Object[])new Object[0]).getLogger();
        logger.log(Level.SEVERE, String.format("%s\nusage: java %s input-file-or-dir [output-dir]", TimeMLAnnotate.class.getName(), message));
        System.exit(1);
    }

    public static void main(String ... args) throws Exception {
        if (args.length != 1 && args.length != 2) {
            TimeMLAnnotate.error("wrong number of arguments");
        } else if (!new File(args[0]).exists()) {
            TimeMLAnnotate.error("file or directory not found: " + args[0]);
        }
        String inputFileOrDir = args[0];
        File outputDir = new File(args.length == 2 ? args[1] : ".");
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        SimplePipeline.runPipeline((CollectionReader)FilesCollectionReader.getCollectionReader((String)inputFileOrDir), (AnalysisEngineDescription[])new AnalysisEngineDescription[]{SentenceAnnotator.getDescription(), TokenAnnotator.getDescription(), PosTaggerAnnotator.getDescription(), DefaultSnowballStemmer.getDescription((String)"English"), ParserAnnotator.getDescription(), TimeAnnotator.FACTORY.getAnnotatorDescription(), TimeTypeAnnotator.FACTORY.getAnnotatorDescription(), EventAnnotator.FACTORY.getAnnotatorDescription(), EventTenseAnnotator.FACTORY.getAnnotatorDescription(), EventAspectAnnotator.FACTORY.getAnnotatorDescription(), EventClassAnnotator.FACTORY.getAnnotatorDescription(), EventPolarityAnnotator.FACTORY.getAnnotatorDescription(), EventModalityAnnotator.FACTORY.getAnnotatorDescription(), TemporalLinkEventToSameSentenceTimeAnnotator.FACTORY.getAnnotatorDescription(), TemporalLinkMainEventToNextSentenceMainEventAnnotator.FACTORY.getAnnotatorDescription(), VerbClauseTemporalAnnotator.FACTORY.getAnnotatorDescription(), TimeMLWriter.getDescription(outputDir.getPath())});
    }
}

