/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.corpus;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.timeml.type.Anchor;
import org.cleartk.timeml.type.Event;
import org.cleartk.timeml.type.TemporalLink;
import org.cleartk.util.ParamUtil;
import org.cleartk.util.ViewURIUtil;
import org.uimafit.component.JCasAnnotator_ImplBase;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.util.JCasUtil;

public class PlainTextTLINKGoldAnnotator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_TLINK_FILE_URL = ConfigurationParameterFactory.createConfigurationParameterName(PlainTextTLINKGoldAnnotator.class, (String)"tlinkFileUrl");
    @ConfigurationParameter(mandatory=true, description="the URL to a plain-text TLINK file, e.g.http://people.cs.kuleuven.be/~steven.bethard/data/timebank-verb-clause.txt")
    private String tlinkFileUrl;
    private Map<String, List<TLINK>> fileTLINKs;

    public void setTlinkFileUrl(String tlinkFileUrl) {
        this.tlinkFileUrl = tlinkFileUrl;
    }

    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(PlainTextTLINKGoldAnnotator.class, (Object[])new Object[]{PARAM_TLINK_FILE_URL, ParamUtil.getParameterValue((String)PARAM_TLINK_FILE_URL, (String)"http://people.cs.kuleuven.be/~steven.bethard/data/timebank-verb-clause.txt")});
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.fileTLINKs = new HashMap<String, List<TLINK>>();
        try {
            String line;
            BufferedReader tlinkFileReader = new BufferedReader(new InputStreamReader(new URL(this.tlinkFileUrl).openStream()));
            while ((line = tlinkFileReader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String[] columns = line.split("\\s+");
                TLINK tlink = new TLINK(columns[1], columns[2], columns[3]);
                if (!this.fileTLINKs.containsKey(columns[0])) {
                    this.fileTLINKs.put(columns[0], new ArrayList());
                }
                this.fileTLINKs.get(columns[0]).add(tlink);
            }
            tlinkFileReader.close();
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        String filePath = ViewURIUtil.getURI((JCas)jCas).getPath();
        String fileBase = new File(filePath).getName().replaceAll("\\..*", "");
        if (this.fileTLINKs.containsKey(fileBase)) {
            HashMap<String, Anchor> anchors = new HashMap<String, Anchor>();
            for (Anchor anchor : JCasUtil.select((JCas)jCas, Anchor.class)) {
                anchors.put(anchor.getId(), anchor);
                if (!(anchor instanceof Event)) continue;
                Event event = (Event)anchor;
                anchors.put(event.getEventInstanceID(), (Anchor)event);
            }
            for (TLINK tlink : this.fileTLINKs.get(fileBase)) {
                int offset = jCas.getDocumentText().length();
                TemporalLink temporalLink = new TemporalLink(jCas, offset, offset);
                Anchor source = this.getAnchor(anchors, tlink.sourceID);
                Anchor target = this.getAnchor(anchors, tlink.targetID);
                temporalLink.setSource(source);
                temporalLink.setTarget(target);
                temporalLink.setRelationType(tlink.relationType);
                temporalLink.addToIndexes();
            }
        }
    }

    private Anchor getAnchor(Map<String, Anchor> anchors, String id) {
        Anchor anchor = anchors.get(id);
        if (anchor == null) {
            throw new RuntimeException(String.format("no anchor for id %s", id));
        }
        return anchor;
    }

    private static class TLINK {
        public String sourceID;
        public String targetID;
        public String relationType;

        public TLINK(String sourceID, String targetID, String relationType) {
            this.sourceID = sourceID;
            this.targetID = targetID;
            this.relationType = relationType;
        }

        public String toString() {
            return String.format("TLINK(%s, %s, %s)", this.sourceID, this.targetID, this.relationType);
        }
    }
}

