/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.eval;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.XMLSerializer;
import org.cleartk.classifier.jar.JarClassifierBuilder;
import org.cleartk.eval.AnnotationStatistics;
import org.cleartk.eval.Evaluation_ImplBase;
import org.cleartk.timeml.corpus.TempEval2010CollectionReader;
import org.cleartk.timeml.corpus.TempEval2010GoldAnnotator;
import org.cleartk.timeml.corpus.TempEval2010Writer;
import org.cleartk.timeml.eval.ModelInfo;
import org.cleartk.util.ViewURIUtil;
import org.uimafit.component.JCasAnnotator_ImplBase;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.factory.AggregateBuilder;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.pipeline.JCasIterable;
import org.uimafit.pipeline.SimplePipeline;
import org.xml.sax.SAXException;

public class TempEval2010Evaluation
extends Evaluation_ImplBase<String, Map<ModelInfo<?>, AnnotationStatistics<String>>> {
    public static final String GOLD_VIEW_NAME = "GoldView";
    public static final String SYSTEM_VIEW_NAME = "_InitialView";
    private File trainDir;
    private File testDir;
    private List<File> dataDirs;
    private List<String> goldAnnotatorParamsForViewsRequiredBySystem;
    private String goldAnnotatorParamForViewAnnotatedBySystem;
    private String timemlWriterParamForViewAnnotatedBySystem;
    private List<AnalysisEngineDescription> preprocessingAnnotators;
    private List<? extends ModelInfo<?>> modelInfos;

    public TempEval2010Evaluation(File trainDir, File testDir, File outputDirectory, List<String> goldAnnotatorParamsForViewsRequiredBySystem, String goldAnnotatorParamForViewAnnotatedBySystem, String timemlWriterParamForViewAnnotatedBySystem, List<AnalysisEngineDescription> preprocessingAnnotators, List<? extends ModelInfo<?>> modelInfos) throws Exception {
        super(outputDirectory);
        this.trainDir = trainDir;
        this.testDir = testDir;
        this.dataDirs = Arrays.asList(trainDir, testDir);
        this.goldAnnotatorParamsForViewsRequiredBySystem = goldAnnotatorParamsForViewsRequiredBySystem;
        this.goldAnnotatorParamForViewAnnotatedBySystem = goldAnnotatorParamForViewAnnotatedBySystem;
        this.timemlWriterParamForViewAnnotatedBySystem = timemlWriterParamForViewAnnotatedBySystem;
        this.preprocessingAnnotators = preprocessingAnnotators;
        this.modelInfos = modelInfos;
    }

    protected CollectionReader getCollectionReader(List<String> items) throws Exception {
        return TempEval2010CollectionReader.getCollectionReader(this.dataDirs, new HashSet<String>(items));
    }

    protected void train(CollectionReader collectionReader, File directory) throws Exception {
        File modelDir;
        AggregateBuilder builder = new AggregateBuilder();
        builder.add(AnalysisEngineFactory.createPrimitiveDescription(XMIReader.class, (Object[])new Object[]{XMIAnnotator.PARAM_XMI_DIRECTORY, this.getXMIDirectory(directory, Stage.TRAIN).getPath()}), new String[0]);
        for (ModelInfo<?> modelInfo : this.modelInfos) {
            File outputDir = modelInfo.getModelSubdirectory(directory);
            builder.add(modelInfo.modelFactory.getWriterDescription(outputDir), new String[0]);
        }
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{builder.createAggregateDescription()});
        for (ModelInfo<?> modelInfo : this.modelInfos) {
            modelDir = modelInfo.getModelSubdirectory(directory);
            JarClassifierBuilder.trainAndPackage((File)modelDir, (String[])modelInfo.trainingArguments);
        }
        for (ModelInfo<?> modelInfo : this.modelInfos) {
            modelDir = modelInfo.modelFactory.getTrainingDirectory();
            if (!modelDir.exists()) continue;
            for (File file : modelDir.listFiles()) {
                if (file.isDirectory() || file.getName().equals("model.jar")) continue;
                file.delete();
            }
        }
    }

    protected Map<ModelInfo<?>, AnnotationStatistics<String>> test(CollectionReader collectionReader, File directory) throws Exception {
        AggregateBuilder builder = new AggregateBuilder();
        builder.add(AnalysisEngineFactory.createPrimitiveDescription(XMIReader.class, (Object[])new Object[]{XMIAnnotator.PARAM_XMI_DIRECTORY, this.getXMIDirectory(directory, Stage.TEST).getPath()}), new String[0]);
        for (ModelInfo<?> modelInfo : this.modelInfos) {
            File modelFile = new File(modelInfo.getModelSubdirectory(directory), "model.jar");
            builder.add(modelInfo.modelFactory.getAnnotatorDescription(modelFile.getPath()), new String[0]);
        }
        builder.add(AnalysisEngineFactory.createPrimitiveDescription(TempEval2010Writer.class, (Object[])new Object[]{TempEval2010Writer.PARAM_OUTPUT_DIRECTORY, new File(directory, "eval").getPath(), TempEval2010Writer.PARAM_TEXT_VIEW, SYSTEM_VIEW_NAME, this.timemlWriterParamForViewAnnotatedBySystem, SYSTEM_VIEW_NAME}), new String[0]);
        HashMap modelInfoToStatistics = new HashMap();
        for (ModelInfo<?> modelInfo : this.modelInfos) {
            modelInfoToStatistics.put(modelInfo, new AnnotationStatistics());
        }
        AnalysisEngine engine = builder.createAggregate();
        for (JCas jCas : new JCasIterable(collectionReader, new AnalysisEngine[]{engine})) {
            JCas goldView = jCas.getView(GOLD_VIEW_NAME);
            JCas systemView = jCas.getView(SYSTEM_VIEW_NAME);
            for (ModelInfo<?> modelInfo : this.modelInfos) {
                AnnotationStatistics statistics = (AnnotationStatistics)modelInfoToStatistics.get(modelInfo);
                modelInfo.updateStatistics((AnnotationStatistics<String>)statistics, goldView, systemView);
            }
        }
        engine.collectionProcessComplete();
        return modelInfoToStatistics;
    }

    private File getXMIDirectory(File directory, Stage stage) throws Exception {
        int dotIndex = Math.max(0, this.goldAnnotatorParamForViewAnnotatedBySystem.lastIndexOf(46));
        String name = this.goldAnnotatorParamForViewAnnotatedBySystem.substring(dotIndex + 1);
        File xmiDirectory = new File(new File(new File(directory, "xmi"), name), stage.toString());
        if (!xmiDirectory.exists()) {
            HashSet<String> fileNames = new HashSet<String>();
            fileNames.addAll(TempEval2010CollectionReader.getAnnotatedFileNames(this.trainDir));
            fileNames.addAll(TempEval2010CollectionReader.getAnnotatedFileNames(this.testDir));
            CollectionReader reader = TempEval2010CollectionReader.getCollectionReader(this.dataDirs, fileNames);
            List<String> viewParams = Arrays.asList(TempEval2010GoldAnnotator.PARAM_TEXT_VIEWS, TempEval2010GoldAnnotator.PARAM_DOCUMENT_CREATION_TIME_VIEWS, TempEval2010GoldAnnotator.PARAM_TIME_EXTENT_VIEWS, TempEval2010GoldAnnotator.PARAM_TIME_ATTRIBUTE_VIEWS, TempEval2010GoldAnnotator.PARAM_EVENT_EXTENT_VIEWS, TempEval2010GoldAnnotator.PARAM_EVENT_ATTRIBUTE_VIEWS, TempEval2010GoldAnnotator.PARAM_TEMPORAL_LINK_EVENT_TO_DOCUMENT_CREATION_TIME_VIEWS, TempEval2010GoldAnnotator.PARAM_TEMPORAL_LINK_EVENT_TO_SAME_SENTENCE_TIME_VIEWS, TempEval2010GoldAnnotator.PARAM_TEMPORAL_LINK_EVENT_TO_SUBORDINATED_EVENT_VIEWS, TempEval2010GoldAnnotator.PARAM_TEMPORAL_LINK_MAIN_EVENT_TO_NEXT_SENTENCE_MAIN_EVENT_VIEWS);
            ArrayList<Object> goldAnnotatorParams = new ArrayList<Object>();
            for (String viewParam : viewParams) {
                String[] paramValue;
                goldAnnotatorParams.add(viewParam);
                switch (stage) {
                    case TRAIN: {
                        String[] stringArray;
                        if (this.goldAnnotatorParamsForViewsRequiredBySystem.contains(viewParam) || viewParam.equals(this.goldAnnotatorParamForViewAnnotatedBySystem)) {
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = SYSTEM_VIEW_NAME;
                        } else {
                            stringArray = new String[]{};
                        }
                        paramValue = stringArray;
                        break;
                    }
                    case TEST: {
                        if (this.goldAnnotatorParamsForViewsRequiredBySystem.contains(viewParam)) {
                            paramValue = new String[]{SYSTEM_VIEW_NAME, GOLD_VIEW_NAME};
                            break;
                        }
                        if (viewParam.equals(this.goldAnnotatorParamForViewAnnotatedBySystem)) {
                            paramValue = new String[]{GOLD_VIEW_NAME};
                            break;
                        }
                        paramValue = new String[]{};
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                goldAnnotatorParams.add(paramValue);
            }
            AggregateBuilder builder = new AggregateBuilder();
            builder.add(AnalysisEngineFactory.createPrimitiveDescription(TempEval2010GoldAnnotator.class, (Object[])goldAnnotatorParams.toArray()), new String[0]);
            for (AnalysisEngineDescription desc : this.preprocessingAnnotators) {
                builder.add(desc, new String[0]);
            }
            builder.add(AnalysisEngineFactory.createPrimitiveDescription(XMIWriter.class, (Object[])new Object[]{XMIAnnotator.PARAM_XMI_DIRECTORY, xmiDirectory.getPath()}), new String[0]);
            SimplePipeline.runPipeline((CollectionReader)reader, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{builder.createAggregateDescription()});
        }
        return xmiDirectory;
    }

    public static class XMIWriter
    extends XMIAnnotator {
        public void initialize(UimaContext context) throws ResourceInitializationException {
            super.initialize(context);
            if (!this.xmiDirectory.exists()) {
                this.xmiDirectory.mkdirs();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            XmiCasSerializer ser = new XmiCasSerializer(jCas.getTypeSystem());
            try {
                FileOutputStream stream = new FileOutputStream(this.getFile(jCas));
                try {
                    ser.serialize(jCas.getCas(), new XMLSerializer((OutputStream)stream, false).getContentHandler());
                }
                finally {
                    stream.close();
                }
            }
            catch (SAXException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (IOException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }

    public static class XMIReader
    extends XMIAnnotator {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            try {
                FileInputStream stream = new FileInputStream(this.getFile(jCas));
                try {
                    XmiCasDeserializer.deserialize((InputStream)stream, (CAS)jCas.getCas());
                }
                finally {
                    stream.close();
                }
            }
            catch (SAXException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (IOException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }

    public static abstract class XMIAnnotator
    extends JCasAnnotator_ImplBase {
        @ConfigurationParameter(mandatory=true)
        protected File xmiDirectory;
        public static final String PARAM_XMI_DIRECTORY = ConfigurationParameterFactory.createConfigurationParameterName(XMIAnnotator.class, (String)"xmiDirectory");

        protected File getFile(JCas jCas) throws AnalysisEngineProcessException {
            return new File(this.xmiDirectory, ViewURIUtil.getURI((JCas)jCas).getFragment() + ".xmi");
        }
    }

    private static enum Stage {
        TRAIN,
        TEST;

    }
}

