/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.eval;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.cleartk.syntax.opennlp.PosTaggerAnnotator;
import org.cleartk.timeml.corpus.TempEval2010GoldAnnotator;
import org.cleartk.timeml.corpus.TempEval2010Writer;
import org.cleartk.timeml.eval.EventModelInfo;
import org.cleartk.timeml.eval.TempEval2010Evaluation;
import org.cleartk.timeml.eval.TempEval2010Main;
import org.cleartk.timeml.event.EventAspectAnnotator;
import org.cleartk.timeml.event.EventClassAnnotator;
import org.cleartk.timeml.event.EventModalityAnnotator;
import org.cleartk.timeml.event.EventPolarityAnnotator;
import org.cleartk.timeml.event.EventTenseAnnotator;
import org.cleartk.token.stem.snowball.DefaultSnowballStemmer;

public class TempEval2010TaskBAttributes
extends TempEval2010Main {
    public static void main(String[] args) throws Exception {
        new TempEval2010TaskBAttributes().runMain(args);
    }

    @Override
    protected TempEval2010Evaluation getEvaluation(File trainDir, File testDir, File outputDir) throws Exception {
        ArrayList<EventModelInfo> infos = new ArrayList<EventModelInfo>();
        infos.add(new EventModelInfo("aspect", EventAspectAnnotator.FACTORY));
        infos.add(new EventModelInfo("eventClass", EventClassAnnotator.FACTORY));
        infos.add(new EventModelInfo("modality", EventModalityAnnotator.FACTORY));
        infos.add(new EventModelInfo("polarity", EventPolarityAnnotator.FACTORY));
        infos.add(new EventModelInfo("tense", EventTenseAnnotator.FACTORY));
        return new TempEval2010Evaluation(trainDir, testDir, outputDir, Arrays.asList(TempEval2010GoldAnnotator.PARAM_TEXT_VIEWS, TempEval2010GoldAnnotator.PARAM_EVENT_EXTENT_VIEWS), TempEval2010GoldAnnotator.PARAM_EVENT_ATTRIBUTE_VIEWS, TempEval2010Writer.PARAM_EVENT_ATTRIBUTE_VIEW, Arrays.asList(DefaultSnowballStemmer.getDescription((String)"English"), PosTaggerAnnotator.getDescription()), infos);
    }
}

