/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.eval;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.uima.jcas.JCas;
import org.cleartk.eval.AnnotationStatistics;
import org.cleartk.timeml.eval.ModelInfo;
import org.cleartk.timeml.type.Anchor;
import org.cleartk.timeml.type.TemporalLink;
import org.cleartk.timeml.util.CleartkInternalModelFactory;
import org.uimafit.util.JCasUtil;

public class TemporalLinkModelInfo
extends ModelInfo<TemporalLink> {
    public TemporalLinkModelInfo(CleartkInternalModelFactory modelFactory, String[] trainingArguments) {
        super(TemporalLink.class, "relationType", TemporalLinkSpanAndRelation.ANNOTATION_CONVERTER, modelFactory, trainingArguments);
    }

    public TemporalLinkModelInfo(CleartkInternalModelFactory modelFactory) {
        this(modelFactory, new String[0]);
    }

    @Override
    public void updateStatistics(AnnotationStatistics<String> statistics, JCas goldView, JCas systemView) {
        Collection goldTlinks = JCasUtil.select((JCas)goldView, (Class)this.annotatedClass);
        Collection systemTlinks = JCasUtil.select((JCas)systemView, (Class)this.annotatedClass);
        HashSet<TemporalLinkSpan> goldSpans = new HashSet<TemporalLinkSpan>();
        for (TemporalLink tlink : goldTlinks) {
            goldSpans.add(new TemporalLinkSpan(tlink));
        }
        ArrayList<TemporalLink> systemTlinksWithGoldSpans = new ArrayList<TemporalLink>();
        for (TemporalLink tlink : systemTlinks) {
            if (!goldSpans.contains(new TemporalLinkSpan(tlink))) continue;
            systemTlinksWithGoldSpans.add(tlink);
        }
        statistics.add(goldTlinks, systemTlinksWithGoldSpans, this.annotationConverter, AnnotationStatistics.annotationToFeatureValue((String)this.annotatedFeatureName));
    }

    private static class TemporalLinkSpanAndRelation {
        public static final Function<TemporalLink, TemporalLinkSpanAndRelation> ANNOTATION_CONVERTER = new Function<TemporalLink, TemporalLinkSpanAndRelation>(){

            public TemporalLinkSpanAndRelation apply(TemporalLink tlink) {
                return new TemporalLinkSpanAndRelation(tlink);
            }
        };
        private TemporalLinkSpan span;
        private String relationType;

        public TemporalLinkSpanAndRelation(TemporalLink tlink) {
            this.span = new TemporalLinkSpan(tlink);
            this.relationType = tlink.getRelationType();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.span, this.relationType});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TemporalLinkSpanAndRelation that = (TemporalLinkSpanAndRelation)obj;
            return Objects.equal((Object)this.span, (Object)that.span) && Objects.equal((Object)this.relationType, (Object)that.relationType);
        }
    }

    private static class TemporalLinkSpan {
        private int sourceBegin;
        private int sourceEnd;
        private int targetBegin;
        private int targetEnd;

        public TemporalLinkSpan(TemporalLink tlink) {
            Anchor source = tlink.getSource();
            Anchor target = tlink.getTarget();
            this.sourceBegin = source.getBegin();
            this.sourceEnd = source.getEnd();
            this.targetBegin = target.getBegin();
            this.targetEnd = target.getEnd();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.sourceBegin, this.sourceEnd, this.targetBegin, this.targetEnd});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TemporalLinkSpan that = (TemporalLinkSpan)obj;
            return this.sourceBegin == that.sourceBegin && this.sourceEnd == that.sourceEnd && this.targetBegin == that.targetBegin && this.targetEnd == that.targetEnd;
        }
    }
}

