/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.classifier.CleartkAnnotator;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.Instance;
import org.cleartk.classifier.feature.extractor.CleartkExtractor;
import org.cleartk.classifier.feature.extractor.CleartkExtractorException;
import org.cleartk.classifier.feature.extractor.simple.CoveredTextExtractor;
import org.cleartk.classifier.feature.extractor.simple.SimpleFeatureExtractor;
import org.cleartk.classifier.feature.extractor.simple.TypePathExtractor;
import org.cleartk.classifier.mallet.MalletStringOutcomeDataWriter;
import org.cleartk.syntax.constituent.type.TreebankNode;
import org.cleartk.syntax.constituent.type.TreebankNodeUtil;
import org.cleartk.timeml.type.Event;
import org.cleartk.timeml.util.CleartkInternalModelFactory;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.util.JCasUtil;

public class EventAnnotator
extends CleartkAnnotator<String> {
    public static final CleartkInternalModelFactory FACTORY = new CleartkInternalModelFactory(){

        @Override
        public Class<?> getAnnotatorClass() {
            return EventAnnotator.class;
        }

        @Override
        public Class<?> getDataWriterClass() {
            return MalletStringOutcomeDataWriter.class;
        }

        @Override
        public AnalysisEngineDescription getBaseDescription() throws ResourceInitializationException {
            return AnalysisEngineFactory.createPrimitiveDescription(EventAnnotator.class, (Object[])new Object[0]);
        }
    };
    protected List<SimpleFeatureExtractor> tokenFeatureExtractors;
    protected List<CleartkExtractor> contextExtractors;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.tokenFeatureExtractors = new ArrayList<SimpleFeatureExtractor>();
        this.tokenFeatureExtractors.addAll(Arrays.asList(new CoveredTextExtractor(), new TypePathExtractor(Token.class, "stem"), new TypePathExtractor(Token.class, "pos"), new ParentNodeFeaturesExtractor()));
        this.contextExtractors = new ArrayList<CleartkExtractor>();
        this.contextExtractors.add(new CleartkExtractor(Token.class, (SimpleFeatureExtractor)new CoveredTextExtractor(), new CleartkExtractor.Context[]{new CleartkExtractor.Preceding(3), new CleartkExtractor.Following(3)}));
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        HashSet<Token> eventTokens = new HashSet<Token>();
        if (this.isTraining()) {
            for (Event event : JCasUtil.select((JCas)jCas, Event.class)) {
                for (Token token : JCasUtil.selectCovered((JCas)jCas, Token.class, (AnnotationFS)event)) {
                    eventTokens.add(token);
                }
            }
        }
        int index = 1;
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            for (Token token : JCasUtil.selectCovered((JCas)jCas, Token.class, (AnnotationFS)sentence)) {
                ArrayList features = new ArrayList();
                for (SimpleFeatureExtractor simpleFeatureExtractor : this.tokenFeatureExtractors) {
                    features.addAll(simpleFeatureExtractor.extract(jCas, (Annotation)token));
                }
                for (CleartkExtractor cleartkExtractor : this.contextExtractors) {
                    features.addAll(cleartkExtractor.extractWithin(jCas, (Annotation)token, (Annotation)sentence));
                }
                if (this.isTraining()) {
                    String label = eventTokens.contains(token) ? "Event" : "O";
                    this.dataWriter.write(new Instance((Object)label, features));
                    continue;
                }
                if (!((String)this.classifier.classify(features)).equals("Event")) continue;
                Event event = new Event(jCas, token.getBegin(), token.getEnd());
                event.setId(String.format("e%d", index));
                event.addToIndexes();
                ++index;
            }
        }
    }

    private static class ParentNodeFeaturesExtractor
    implements SimpleFeatureExtractor {
        public List<Feature> extract(JCas view, Annotation focusAnnotation) throws CleartkExtractorException {
            TreebankNode parent;
            TreebankNode node = TreebankNodeUtil.selectMatchingLeaf((JCas)view, (Annotation)focusAnnotation);
            ArrayList<Feature> features = new ArrayList<Feature>();
            if (node != null && (parent = node.getParent()) != null) {
                features.add(new Feature("ParentNodeType", (Object)parent.getNodeType()));
                TreebankNode firstSibling = parent.getChildren(0);
                if (firstSibling != node && firstSibling.getLeaf()) {
                    features.add(new Feature("FirstSiblingText", (Object)firstSibling.getCoveredText()));
                }
            }
            return features;
        }
    }
}

