/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.time;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.classifier.CleartkAnnotator;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.Instance;
import org.cleartk.classifier.feature.extractor.CleartkExtractor;
import org.cleartk.classifier.feature.extractor.simple.CharacterCategoryPatternExtractor;
import org.cleartk.classifier.feature.extractor.simple.CoveredTextExtractor;
import org.cleartk.classifier.feature.extractor.simple.SimpleFeatureExtractor;
import org.cleartk.classifier.opennlp.MaxentStringOutcomeDataWriter;
import org.cleartk.timeml.type.Time;
import org.cleartk.timeml.util.CleartkInternalModelFactory;
import org.cleartk.timeml.util.TimeWordsExtractor;
import org.cleartk.token.type.Token;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.util.JCasUtil;

public class TimeTypeAnnotator
extends CleartkAnnotator<String> {
    public static final CleartkInternalModelFactory FACTORY = new CleartkInternalModelFactory(){

        @Override
        public Class<?> getAnnotatorClass() {
            return TimeTypeAnnotator.class;
        }

        @Override
        public Class<?> getDataWriterClass() {
            return MaxentStringOutcomeDataWriter.class;
        }

        @Override
        public AnalysisEngineDescription getBaseDescription() throws ResourceInitializationException {
            return AnalysisEngineFactory.createPrimitiveDescription(TimeTypeAnnotator.class, (Object[])new Object[0]);
        }
    };
    private List<SimpleFeatureExtractor> featuresExtractors;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.featuresExtractors = Arrays.asList(new LastWordExtractor(), new CharacterCategoryPatternExtractor(CharacterCategoryPatternExtractor.PatternType.REPEATS_MERGED), new TimeWordsExtractor(), new CleartkExtractor(Token.class, (SimpleFeatureExtractor)new CoveredTextExtractor(), new CleartkExtractor.Context[]{new CleartkExtractor.Bag(new CleartkExtractor.Context[]{new CleartkExtractor.Covered()})}));
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Time time : JCasUtil.select((JCas)jCas, Time.class)) {
            ArrayList features = new ArrayList();
            for (SimpleFeatureExtractor extractor : this.featuresExtractors) {
                features.addAll(extractor.extract(jCas, (Annotation)time));
            }
            if (this.isTraining()) {
                this.dataWriter.write(new Instance((Object)time.getTimeType(), features));
                continue;
            }
            time.setTimeType((String)this.classifier.classify(features));
        }
    }

    private static class LastWordExtractor
    implements SimpleFeatureExtractor {
        public List<Feature> extract(JCas view, Annotation focusAnnotation) {
            String[] words = focusAnnotation.getCoveredText().split("\\W+");
            return Arrays.asList(new Feature("LastWord", (Object)words[words.length - 1]));
        }
    }
}

