/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.tlink;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.classifier.feature.extractor.simple.CoveredTextExtractor;
import org.cleartk.classifier.feature.extractor.simple.SimpleFeatureExtractor;
import org.cleartk.classifier.feature.extractor.simple.TypePathExtractor;
import org.cleartk.classifier.opennlp.MaxentStringOutcomeDataWriter;
import org.cleartk.timeml.tlink.TemporalLinkAnnotator_ImplBase;
import org.cleartk.timeml.type.DocumentCreationTime;
import org.cleartk.timeml.type.Event;
import org.cleartk.timeml.util.CleartkInternalModelFactory;
import org.cleartk.timeml.util.FilteringExtractor;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.util.JCasUtil;

public class TemporalLinkEventToDocumentCreationTimeAnnotator
extends TemporalLinkAnnotator_ImplBase<Event, DocumentCreationTime> {
    public static final CleartkInternalModelFactory FACTORY = new CleartkInternalModelFactory(){

        @Override
        public Class<?> getAnnotatorClass() {
            return TemporalLinkEventToDocumentCreationTimeAnnotator.class;
        }

        @Override
        public Class<?> getDataWriterClass() {
            return MaxentStringOutcomeDataWriter.class;
        }

        @Override
        public AnalysisEngineDescription getBaseDescription() throws ResourceInitializationException {
            return AnalysisEngineFactory.createPrimitiveDescription(TemporalLinkEventToDocumentCreationTimeAnnotator.class, (Object[])new Object[0]);
        }
    };

    public TemporalLinkEventToDocumentCreationTimeAnnotator() {
        super(Event.class, DocumentCreationTime.class, "BEFORE", "OVERLAP", "AFTER");
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.setSourceExtractors(Arrays.asList(new TypePathExtractor(Event.class, "tense"), new TypePathExtractor(Event.class, "aspect"), new TypePathExtractor(Event.class, "eventClass"), new TypePathExtractor(Event.class, "polarity"), new TypePathExtractor(Event.class, "modality"), new FilteringExtractor<Event>(Event.class, (SimpleFeatureExtractor)new CoveredTextExtractor()){

            @Override
            protected boolean accept(Event event) {
                return event.getEventClass().equals("ASPECTUAL");
            }
        }));
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Map links = this.getLinks(jCas);
        Collection dcts = JCasUtil.select((JCas)jCas, DocumentCreationTime.class);
        if (dcts.size() != 1) {
            throw new RuntimeException("expected 1 DocumentCreationTime, found " + dcts.size());
        }
        DocumentCreationTime dct = (DocumentCreationTime)dcts.iterator().next();
        for (Event event : JCasUtil.select((JCas)jCas, Event.class)) {
            this.processLink(event, dct, links, jCas);
        }
        this.logSkippedLinks(jCas, links);
    }
}

